//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStackTrace.cpp
 * @brief		X^bNg[XNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXStackTrace_CPP_

//======================================================================
// include
#include "WXStackTrace.h"
#include "WXStackWalker.h"
#include "../../base/WXError.h"
#include "WXDebugHelp.h"
#include "../../../../../iris_xchar.hpp"
#include "../../../../../iris_debug.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// typedef
typedef BOOL (WINAPI *PFN_CloseHandle)(HANDLE hHandle);

//======================================================================
// struct
typedef struct tagTHREAD_ARGS
{
	CStackTrace*	pStackTrace;
	int				count;
	u32				flags;
} THREAD_ARGS;

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStackTrace::CStackTrace(void)
: m_hCurrentProcess(nullptr)
{
	m_pfnDuplicateHandle = ::DuplicateHandle;
	m_Info.filename[0] = TEXT('\0');
	m_Info.symbol[0] = TEXT('\0');
	m_Info.line = 0;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStackTrace::~CStackTrace(void)
{
}

/**********************************************************************//**
 *
 * g[X
 *
 -----------------------------------------------------------------------
 * @param [in]	count	= H
 * @param [in]	flags	= g[XtO
 * @return	
*//***********************************************************************/
bool CStackTrace::Trace(int count, u32 flags)
{
	IRIS_ASSERT( m_hCurrentProcess == nullptr );
	IRIS_ASSERT( !m_Thread.IsValid() );

	HANDLE hProcess = ::GetCurrentProcess();
	HANDLE hThreadTmp = ::GetCurrentThread();
	HANDLE hThread = nullptr;

	if( !(*m_pfnDuplicateHandle)(hProcess, hThreadTmp, hProcess, &hThread, 0 , FALSE , DUPLICATE_SAME_ACCESS) )
	{
		return false;
	}
	m_hCurrentProcess = hProcess;
	m_CurrentThread.Attach(hThread);

	THREAD_ARGS args = { this, count, flags };
	m_Thread.CreateStart((PROC)_Entry, &args);

	DWORD dwExitCode = m_Thread.Wait();

	m_Thread.Close();
	m_CurrentThread.Close();
	m_hCurrentProcess = nullptr;

	return dwExitCode == 0;
}

/**********************************************************************//**
 *
 * g[Xs
 *
 -----------------------------------------------------------------------
 * @param [in]	count	= H
 * @param [in]	flags	= g[XtO
 * @return	
*//***********************************************************************/
bool CStackTrace::OnTrace(int count, u32 flags)
{
	CStackWalker walker;

	if( !walker.Begin(m_hCurrentProcess, m_CurrentThread) ) return false;

	bool ret = false;
	while(count)
	{
		if( !walker.Walk(nullptr, CDbgHelpModule::GetSymFunctionTableAccessProc(), CDbgHelpModule::GetSymGetModuleBaseProc(), nullptr) )
		{
			break;
		}

		--count;
		if( count == 0 || (flags & EXAMINE_EACH) )
		{
			walker.GetSymbolName(m_Info.symbol, MAX_PATH);

			// sԍ̎擾
			IMAGEHLP_LINE line = { sizeof(IMAGEHLP_LINE) };
			if( !walker.GetLine(&line) )
			{
				line.FileName = nullptr;
			}
			if( line.FileName != nullptr )
			{
				xcstoxcs_s(m_Info.filename, MAX_PATH, line.FileName);
			}
			else
			{
				m_Info.filename[0] = TEXT('\0');
			}
			m_Info.symbol[MAX_PATH-1] = TEXT('\0');
			m_Info.line = line.LineNumber;

			if( flags & SKIP_UNKOWN_SOURCE )
			{
				// t@CŔ
				DWORD dwAttr = ::GetFileAttributesA(line.FileName);
				if( dwAttr == (DWORD)-1 )
				{
					++count;
					continue;
				}
			}

			if( IsSkip(m_Info) )
			{
				++count;
				continue;
			}

			if( count == 0 )
			{
				ret = true;
				break;
			}
		}
	}

	walker.End();
	return ret;
}

/**********************************************************************//**
 *
 * Gg
 *
*//***********************************************************************/
UINT CStackTrace::Entry(int count, u32 flags)
{
	// ΏۃXbh~
	m_CurrentThread.Suspend();

	// g[Xs
	bool ret = OnTrace(count, flags);

	// ΏۃXbh𕜋A
	m_CurrentThread.Resume();

	return ret ? 0u : 1u;
}

/**********************************************************************//**
 *
 * Gg
 *
 -----------------------------------------------------------------------
 * @param [in]	pUser	= THREAD_ARGS*
 * @return	
*//***********************************************************************/
UINT WINAPI CStackTrace::_Entry(void* pUser)
{
	IRIS_ASSERT( pUser != nullptr );
	THREAD_ARGS* args = static_cast<THREAD_ARGS*>(pUser);
	CStackTrace* p = args->pStackTrace;
	return p->Entry(args->count, args->flags);
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris
