//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDirectoryEntry.h
 * @brief		DIRECTORY ENTRY t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDirectoryEntry_H_
#define INCG_IRIS_WXDirectoryEntry_H_

//======================================================================
// include
#include "../../../../../iris_object.h"
#include "WXDebugHelp.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
template<USHORT ENTRY>
class CImageDirectoryEntry : public IIrisObject
{
	typedef CImageDirectoryEntry<ENTRY>	_Myt;
	template<USHORT DE>struct type_impl { typedef DWORD value_type; };
	template<>struct type_impl<IMAGE_DIRECTORY_ENTRY_IMPORT>	{ typedef IMAGE_IMPORT_DESCRIPTOR	value_type; };
	template<>struct type_impl<IMAGE_DIRECTORY_ENTRY_EXPORT>	{ typedef IMAGE_EXPORT_DIRECTORY	value_type; };
	template<>struct type_impl<IMAGE_DIRECTORY_ENTRY_IAT>		{ typedef PROC	value_type; };

public:
	typedef typename type_impl<ENTRY>::value_type	value_type;
	typedef value_type								*value_ptr;
	typedef value_type								&value_ref;

public:
	value_ptr	m_pEntry;	//!< Gg[
	ULONG		m_nSize;	//!< TCY

public:
	/// RXgN^
	CImageDirectoryEntry(PVOID pBase, BOOLEAN bMappedAsImage)
		: m_pEntry(nullptr)
		, m_nSize(0)
	{
		m_pEntry = ToData(pBase, bMappedAsImage, &m_nSize);
	}

	CImageDirectoryEntry(const CImageDirectoryEntry& rhs)
		: m_pEntry(rhs.m_pEntry)
		, m_nSize(rhs.m_nSize)
	{
	}

public:
	value_ref	operator *  (void)			{ return *m_pEntry; }
	value_ptr	operator ->	(void)	const	{ return m_pEntry; }
	value_ptr	ptr(void)			const	{ return m_pEntry; }

	operator value_ptr		(void)	const	{ return m_pEntry; }

public:
	_Myt&		operator ++ (void)	{ ++m_pEntry; return *this; }
	_Myt		operator ++ (int)	{ _Myt tmp(*this); ++m_pEntry; return tmp; }

public:
	/// TCY擾
	ULONG		GetSize(void)	const	{ return m_nSize; }
	/// vf̎擾
	ULONG		GetCount(void)	const	{ return m_nSize / sizeof(value_type); }

public:
	/// LȃIuWFNgǂ
	bool		IsValid(void)	const	{ return m_pEntry != nullptr; }

public:
	/// f[^擾
	static value_ptr	ToData(PVOID pBase, BOOLEAN bMappedAsImage, PULONG pSize)
	{
		return static_cast<value_ptr>(CDbgHelpModule::ImageDirectoryEntryToData(pBase, bMappedAsImage, ENTRY, pSize));
	}
	/// f[^擾
	static value_ptr	ToData(PVOID pBase, BOOLEAN bMappedAsImage)
	{
		ULONG uSize = 0;
		return ToData(pBase, bMappedAsImage, &uSize);
	}

public:
	/**
	 * @brief	֐|C^[̌
	 * @param [in]	pfnTarget	= ֐|C^[
	 * @param [in]	hModule		= W[iɗpj
	*/
	PROC*	FindProcAddress(PROC pfnTarget, HMODULE hModule)
	{
		return Finder::Find(*this, pfnTarget, hModule);
	}

public:
	/**
	 * @brief	֐|C^[̌
	 * @param [in]	pfnTarget	= ֐|C^[
	 * @param [in]	hModule		= W[iɗpj
	*/
	static PROC*	FindProcAddress(PROC pfnTarget, HMODULE hModule, BOOLEAN bMappedAsImage)
	{
		return Finder::Find(pfnTarget, hModule, bMappedAsImage);
	}

private:
	/**
	 * @biref	֐|C^[i[AhXNX
	*/
	class Finder
	{
		template<typename T, typename DMY>
		struct impl;
		template<typename DMY>
		struct impl<PROC, DMY>
		{
			static PROC*	Find(_Myt& pidesc, PROC pfnTarget, HMODULE hModule)
			{
				if( pidesc == nullptr ) return nullptr;

				for( ULONG i=0, count=pidesc.GetCount(); i < count; ++i, ++pidesc ) 
				{
					PROC* ppfn = pointer_cast<PROC*>(pidesc);
					if( *ppfn == pfnTarget )
					{
						return ppfn;
					}
				}
				return nullptr;
			}
		};
		template<typename DMY>
		struct impl<IMAGE_IMPORT_DESCRIPTOR, DMY>
		{
			static PROC*	Find(_Myt& pidesc, PROC pfnTarget, HMODULE hModule)
			{
				if( pidesc == nullptr ) return nullptr;

				while( pidesc->Name )
				{
#if 1	// fobOAœKp
					LPCSTR lpName = pointer_cast<LPCSTR>((PBYTE)hModule + pidesc->Name);
					IRIS_UNUSED_VAR(lpName);
#endif
					PIMAGE_THUNK_DATA pitd = pointer_cast<PIMAGE_THUNK_DATA>((PBYTE)hModule + pidesc->FirstThunk);

					while( pitd->u1.Function )
					{
						PROC* ppfn = pointer_cast<PROC*>(&pitd->u1.Function);
						if( *ppfn == pfnTarget )
						{
							return ppfn;
						}
						++pitd;
					}
					++pidesc;
				}
				return nullptr;
			}
		};
	public:
		static inline PROC*	Find(_Myt& pidesc, PROC pfnTarget, HMODULE hModule)
		{
			return impl<value_type, void>::Find(pidesc, pfnTarget, hModule);
		}
		static inline PROC*	Find(PROC pfnTarget, HMODULE hModule, BOOLEAN bMappedAsImage)
		{
			_Myt pidesc((PVOID)hModule, bMappedAsImage);
			return Find(pidesc, pfnTarget, hModule);
		}
	};
};

}	// end of namespace wx
}	// end of namespace iris

#endif
