//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDbgModule.cpp
 * @brief		fobOW[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDbgModule_CPP_

//======================================================================
// include
#include "WXDbgModule.h"
#include "WXDebugHelp.h"
#include "WXImageDirectoryEntry.h"
#include "../../../../../iris_iostream.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// function
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDbgModule::DumpDllFunctionName(void)
{
	HMODULE hModule = reinterpret_cast<HMODULE>(m_hObject);
	char**	ppszFunctionName;
	WORD*	pwFunctionOrdinal;
	CImageDirectoryEntry<IMAGE_DIRECTORY_ENTRY_EXPORT> pImageExportDir((PVOID)hModule, TRUE);
	if(pImageExportDir == nullptr)
	{
		return false;
	}

	//pImageExportDir̃AhXhModulȇΓIȃAhX
	ppszFunctionName	= (char**)(pImageExportDir->AddressOfNames + (UINT_PTR)hModule);
	pwFunctionOrdinal	= (WORD*)(pImageExportDir->AddressOfNameOrdinals + (UINT_PTR)hModule);

	std::cout.setf( std::ios::hex );
	for(DWORD i = 0; i < pImageExportDir->NumberOfFunctions; ++i)
	{
		std::cout.setf( std::ios::dec );
		std::cout << "F" << pImageExportDir->Base + i ;
		std::cout.unsetf( std::ios::dec );
		std::cout << "(0x" << pImageExportDir->Base + i << "j";

		for(DWORD j = 0; j < pImageExportDir->NumberOfNames; j++)
		{
			if(pwFunctionOrdinal[j] != i)		// pwFunctionOrdinal[j]͏ł͂ȂCfbNX
				continue;

			// hModulȇ΃AhXŊ֐i[Ă
			std::cout << "@֐F" << (char*)(ppszFunctionName[j] + (ULONGLONG)hModule) << std::endl;
			break;
		}
	}
	return true;
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )
#include "unit/UnitCore.h"
#include "../../os/WXModule.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXDebugHelpUnitTest, Func)
{
	printf("dll̃pX͂ĂB\n");
	CHAR path[MAX_PATH];
	std::cin >> path;

	iris::wx::dbg::CDbgModule module;
	if( !module.Load(path) ) return;

	module.DumpDllFunctionName();

}

#endif
