//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXExceptionFilter.h
 * @brief		WXExceptionFilter t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXExceptionFilter_H_
#define INCG_IRIS_WXExceptionFilter_H_

//======================================================================
// include
#include "../../../../iris_object.h"

//======================================================================
// define
#ifndef STATUS_POSSIBLE_DEADLOCK
#  define STATUS_POSSIBLE_DEADLOCK         ((NTSTATUS)0xC0000194L)
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ExceptionFilter NX
 * @tparam	CRTP pĂяoIuWFNg
*/
template<typename TN>
class CExceptionFilter : public IIrisObject
{
	typedef TN	CRTP;
protected:
	LPTOP_LEVEL_EXCEPTION_FILTER	m_pfnOrigin;	//!< ̃nh

public:
	/// RXgN^
	CExceptionFilter(void)
		: m_pfnOrigin(nullptr)
	{
	}
	/// fXgN^
	virtual ~CExceptionFilter(void)
	{
		TearDown();
	}
public:
	/// ݒ
	void	Setup(void)
	{
		m_pfnOrigin = SetUnhandledExceptionFilter(CRTP::ExceptionFilter);
	}
	/// ݒ
	void	TearDown(void)
	{
		if( m_pfnOrigin != nullptr )
		{
			SetUnhandledExceptionFilter(m_pfnOrigin);
		}
	}
	
public:
	static LONG WINAPI ExceptionFilter(struct _EXCEPTION_POINTERS *ExceptionInfo)
	{
		return EXCEPTION_CONTINUE_SEARCH;
	}

public:
	/// OR[h̃bZ[W擾
	static const LPCTSTR	FormatExceptionMessage(DWORD dwExceptionCode)
	{
#ifdef UNICODE
		return FormatExceptionMessageW(dwExceptionCode);
#else
		return FormatExceptionMessageA(dwExceptionCode);
#endif
	}

	static const LPCSTR		FormatExceptionMessageA(DWORD dwExceptionCode)
	{
		switch( dwExceptionCode )
		{
		case EXCEPTION_ACCESS_VIOLATION:
			return "EXCEPTION_ACCESS_VIOLATION";
		case EXCEPTION_DATATYPE_MISALIGNMENT:
			return "EXCEPTION_DATATYPE_MISALIGNMENT";
		case EXCEPTION_BREAKPOINT:
			return "EXCEPTION_BREAKPOINT";
		case EXCEPTION_SINGLE_STEP:
			return "EXCEPTION_SINGLE_STEP";
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			return "EXCEPTION_ARRAY_BOUNDS_EXCEEDED";
		case EXCEPTION_FLT_DENORMAL_OPERAND:
			return "EXCEPTION_FLT_DENORMAL_OPERAND";
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
			return "EXCEPTION_FLT_DIVIDE_BY_ZERO";
		case EXCEPTION_FLT_INEXACT_RESULT:
			return "EXCEPTION_FLT_INEXACT_RESULT";
		case EXCEPTION_FLT_INVALID_OPERATION:
			return "EXCEPTION_FLT_INVALID_OPERATION";
		case EXCEPTION_FLT_OVERFLOW:
			return "EXCEPTION_FLT_OVERFLOW";
		case EXCEPTION_FLT_STACK_CHECK:
			return "EXCEPTION_FLT_STACK_CHECK";
		case EXCEPTION_FLT_UNDERFLOW:
			return "EXCEPTION_FLT_UNDERFLOW";
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
			return "EXCEPTION_INT_DIVIDE_BY_ZERO";
		case EXCEPTION_INT_OVERFLOW:
			return "EXCEPTION_INT_OVERFLOW";
		case EXCEPTION_PRIV_INSTRUCTION:
			return "EXCEPTION_PRIV_INSTRUCTION";
		case EXCEPTION_IN_PAGE_ERROR:
			return "EXCEPTION_IN_PAGE_ERROR";
		case EXCEPTION_ILLEGAL_INSTRUCTION:
			return "EXCEPTION_ILLEGAL_INSTRUCTION";
		case EXCEPTION_NONCONTINUABLE_EXCEPTION:
			return "EXCEPTION_NONCONTINUABLE_EXCEPTION";
		case EXCEPTION_STACK_OVERFLOW:
			return "EXCEPTION_STACK_OVERFLOW";
		case EXCEPTION_INVALID_DISPOSITION:
			return "EXCEPTION_INVALID_DISPOSITION";
		case EXCEPTION_GUARD_PAGE:
			return "EXCEPTION_GUARD_PAGE";
		case EXCEPTION_INVALID_HANDLE:
			return "EXCEPTION_INVALID_HANDLE";
		case EXCEPTION_POSSIBLE_DEADLOCK:
			return "EXCEPTION_POSSIBLE_DEADLOCK";
		}
		return "Unkown Exception.";
	};
	static const LPCWSTR	FormatExceptionMessageW(DWORD dwExceptionCode)
	{
		switch( dwExceptionCode )
		{
		case EXCEPTION_ACCESS_VIOLATION:
			return L"EXCEPTION_ACCESS_VIOLATION";
		case EXCEPTION_DATATYPE_MISALIGNMENT:
			return L"EXCEPTION_DATATYPE_MISALIGNMENT";
		case EXCEPTION_BREAKPOINT:
			return L"EXCEPTION_BREAKPOINT";
		case EXCEPTION_SINGLE_STEP:
			return L"EXCEPTION_SINGLE_STEP";
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			return L"EXCEPTION_ARRAY_BOUNDS_EXCEEDED";
		case EXCEPTION_FLT_DENORMAL_OPERAND:
			return L"EXCEPTION_FLT_DENORMAL_OPERAND";
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
			return L"EXCEPTION_FLT_DIVIDE_BY_ZERO";
		case EXCEPTION_FLT_INEXACT_RESULT:
			return L"EXCEPTION_FLT_INEXACT_RESULT";
		case EXCEPTION_FLT_INVALID_OPERATION:
			return L"EXCEPTION_FLT_INVALID_OPERATION";
		case EXCEPTION_FLT_OVERFLOW:
			return L"EXCEPTION_FLT_OVERFLOW";
		case EXCEPTION_FLT_STACK_CHECK:
			return L"EXCEPTION_FLT_STACK_CHECK";
		case EXCEPTION_FLT_UNDERFLOW:
			return L"EXCEPTION_FLT_UNDERFLOW";
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
			return L"EXCEPTION_INT_DIVIDE_BY_ZERO";
		case EXCEPTION_INT_OVERFLOW:
			return L"EXCEPTION_INT_OVERFLOW";
		case EXCEPTION_PRIV_INSTRUCTION:
			return L"EXCEPTION_PRIV_INSTRUCTION";
		case EXCEPTION_IN_PAGE_ERROR:
			return L"EXCEPTION_IN_PAGE_ERROR";
		case EXCEPTION_ILLEGAL_INSTRUCTION:
			return L"EXCEPTION_ILLEGAL_INSTRUCTION";
		case EXCEPTION_NONCONTINUABLE_EXCEPTION:
			return L"EXCEPTION_NONCONTINUABLE_EXCEPTION";
		case EXCEPTION_STACK_OVERFLOW:
			return L"EXCEPTION_STACK_OVERFLOW";
		case EXCEPTION_INVALID_DISPOSITION:
			return L"EXCEPTION_INVALID_DISPOSITION";
		case EXCEPTION_GUARD_PAGE:
			return L"EXCEPTION_GUARD_PAGE";
		case EXCEPTION_INVALID_HANDLE:
			return L"EXCEPTION_INVALID_HANDLE";
		case EXCEPTION_POSSIBLE_DEADLOCK:
			return L"EXCEPTION_POSSIBLE_DEADLOCK";
		}
		return L"Unkown Exception.";
	};
};

}	// end of namespace wx
}	// end of namespace iris

#endif
