//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRichTextParams.cpp
 * @brief		b`GfBbgRg[gp̍\̋@\gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXRichTextParams_CPP_

//======================================================================
// include
#include "WXRichTextParams.h"
#include "../../gdi/WXWndDC.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CHARFORMATNX
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename _TN>
ICharFormat<_TN>::ICharFormat(void)
{
	ZeroMemory(&m_Fmt, sizeof(Format));
	m_Fmt.cbSize = sizeof(Format);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	rFormat	= CHARFORMAT
*//***********************************************************************/
template<typename _TN>
ICharFormat<_TN>::ICharFormat(const Format& rFormat)
{
	memcpy(&m_Fmt, &rFormat, sizeof(Format));
	m_Fmt.cbSize = sizeof(Format);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename _TN>
ICharFormat<_TN>::~ICharFormat(void)
{
}

/**********************************************************************//**
 *
 * Lɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableEffects(DWORD dwCFM, DWORD dwCFE)
{
	m_Fmt.dwMask	|= dwCFM;
	m_Fmt.dwEffects	|= dwCFE;
}
/**********************************************************************//**
 *
 * ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableEffects(DWORD dwCFM, DWORD dwCFE)
{
	IRIS_UNUSED_VARIABLE(dwCFM);
//	m_Fmt.dwMask	&= ~dwCFM;
	m_Fmt.dwEffects	&= ~dwCFE;
}
/**********************************************************************//**
 *
 * Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsEffects(DWORD dwCFM, DWORD dwCFE) const
{
	return ( (m_Fmt.dwMask & dwCFM) && (m_Fmt.dwEffects & dwCFE) );
}

/**********************************************************************//**
 *
 * ̍ݒ(twipP)
 *
 ----------------------------------------------------------------------
 * @param [in]	lHeight	= ̍
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetCharHeightTwip(LONG lHeight)
{
	m_Fmt.yHeight	= lHeight;
}
/**********************************************************************//**
 *
 * ̍擾(twipP)
 *
 ----------------------------------------------------------------------
 * @return	̍
*//***********************************************************************/
template<typename _TN>
LONG ICharFormat<_TN>::GetCharHeightTwip(void) const
{
	return m_Fmt.yHeight;
}
/**********************************************************************//**
 *
 * ̍ݒipixelPʁj
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ϊp̃nh
 * @param [in]	lHeight	= ̍
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetCharHeightPixel(HWND hWnd, LONG lHeight)
{
	CWndDC hDC(hWnd);
	int lpy = hDC.GetDeviceCaps(LOGPIXELSY);
	m_Fmt.yHeight = IRIS_Pixel2Twip(lHeight, lpy);
}
/**********************************************************************//**
 *
 * ̍擾ipixelPʁj
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ϊp̃nh
 * @return	̍
*//***********************************************************************/
template<typename _TN>
LONG ICharFormat<_TN>::GetCharHeightPixel(HWND hWnd) const
{
	CWndDC hDC(hWnd);
	int lpy = hDC.GetDeviceCaps(LOGPIXELSY);
	LONG ret = IRIS_Twip2Pixel(m_Fmt.yHeight, lpy);
	return ret;
}
/**********************************************************************//**
 *
 * ̍ݒ(pointP)
 *
 ----------------------------------------------------------------------
 * @param [in]	lHeight	= ̍
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetCharHeightPoint(LONG lHeight)
{
	m_Fmt.yHeight = IRIS_Point2Twip(lHeight);
}
/**********************************************************************//**
 *
 * ̍擾(pointP)
 *
 ----------------------------------------------------------------------
 * @return	̍
*//***********************************************************************/
template<typename _TN>
LONG ICharFormat<_TN>::GetCharHeightPoint(void) const
{
	return IRIS_Twip2Point(m_Fmt.yHeight);
}
/**********************************************************************//**
 *
 * ̍ݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableCharHeight(void)
{
	m_Fmt.dwMask	|= CFM_SIZE;
}
/**********************************************************************//**
 *
 * ̍ݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableCharHeight(void)
{
	m_Fmt.dwMask	&= ~CFM_SIZE;
}
/**********************************************************************//**
 *
 * ̍ݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsCharHeight(void) const
{
	return (m_Fmt.dwMask & CFM_SIZE) != 0;
}

/**********************************************************************//**
 *
 * LN^Zbgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	byCharSet	= LN^Zbg
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetCharSet(BYTE byCharSet)
{
	m_Fmt.bCharSet	= byCharSet;
}
/**********************************************************************//**
 *
 * LN^Zbg擾
 *
 ----------------------------------------------------------------------
 * @return	LN^Zbg
*//***********************************************************************/
template<typename _TN>
BYTE ICharFormat<_TN>::GetCharSet(void) const
{
	return m_Fmt.bCharSet;
}
/**********************************************************************//**
 *
 * LN^ZbgݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableCharSet(void)
{
	m_Fmt.dwMask	|= CFM_CHARSET;
}
/**********************************************************************//**
 *
 * LN^Zbgݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableCharSet(void)
{
	m_Fmt.dwMask	&= ~CFM_CHARSET;
}
/**********************************************************************//**
 *
 * LN^Zbgݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsCharSet(void) const
{
	return (m_Fmt.dwMask & CFM_CHARSET) != 0;
}

/**********************************************************************//**
 *
 * x[XC̃ItZbgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lHeight	= x[XC̃ItZbg
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetOffset(LONG lOffset)
{
	m_Fmt.yOffset	= lOffset;
}
/**********************************************************************//**
 *
 * x[XC̃ItZbg擾
 *
 ----------------------------------------------------------------------
 * @return	x[XC̃ItZbg
*//***********************************************************************/
template<typename _TN>
LONG ICharFormat<_TN>::GetOffset(void) const
{
	return m_Fmt.yOffset;
}
/**********************************************************************//**
 *
 * x[XC̃ItZbgݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableOffset(void)
{
	m_Fmt.dwMask	|= CFM_OFFSET;
}
/**********************************************************************//**
 *
 * x[XC̃ItZbgݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableOffset(void)
{
	m_Fmt.dwMask	&= ~CFM_OFFSET;
}
/**********************************************************************//**
 *
 * x[XC̃ItZbgݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsOffset(void) const
{
	return (m_Fmt.dwMask & CFM_OFFSET) != 0;
}

/**********************************************************************//**
 *
 * Fݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= F
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetTextColor(COLORREF color)
{
	m_Fmt.crTextColor = color;
}
/**********************************************************************//**
 *
 * F擾
 *
 ----------------------------------------------------------------------
 * @return	F
*//***********************************************************************/
template<typename _TN>
COLORREF ICharFormat<_TN>::GetTextColor(void) const
{
	return m_Fmt.crTextColor;
}
/**********************************************************************//**
 *
 * F̐ݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableTextColor(void)
{
	m_Fmt.dwMask	|= CFM_COLOR;
}
/**********************************************************************//**
 *
 * F̐ݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableTextColor(void)
{
	m_Fmt.dwMask	&= ~CFM_COLOR;
}
/**********************************************************************//**
 *
 * F̐ݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsTextColor(void) const
{
	return (m_Fmt.dwMask & CFM_COLOR) != 0;
}
/**********************************************************************//**
 *
 * FݒVXeJ[ɂ
 * (COLOR_WINDOWTEXTɂȂ)
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableAutoTextColor(void)
{
	m_Fmt.dwEffects |= CFE_AUTOCOLOR;
}
/**********************************************************************//**
 *
 * FݒVXeJ[ɂ̂
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableAutoTextColor(void)
{
	m_Fmt.dwEffects &= ~CFE_AUTOCOLOR;
}
/**********************************************************************//**
 *
 * Fݒ肪VXeJ[ݒ肩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsAutoTextColor(void) const
{
	return ( (m_Fmt.dwMask & CFM_COLOR) && (m_Fmt.dwEffects & CFE_AUTOCOLOR) );
}

/**********************************************************************//**
 *
 * tHgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFace	= tHg
*//***********************************************************************/
template<>
void ICharFormat<CHARFORMATA>::SetFontFace(LPVOID lpszFace)
{
	strcpy_s(m_Fmt.szFaceName, LF_FACESIZE, (LPCSTR)lpszFace);
}
template<>
void ICharFormat<CHARFORMATW>::SetFontFace(LPVOID lpszFace)
{
	wcscpy_s(m_Fmt.szFaceName, LF_FACESIZE, (LPCWSTR)lpszFace);
}
template<>
void ICharFormat<CHARFORMAT2A>::SetFontFace(LPVOID lpszFace)
{
	strcpy_s(m_Fmt.szFaceName, LF_FACESIZE, (LPCSTR)lpszFace);
}
template<>
void ICharFormat<CHARFORMAT2W>::SetFontFace(LPVOID lpszFace)
{
	wcscpy_s(m_Fmt.szFaceName, LF_FACESIZE, (LPCWSTR)lpszFace);
}

/**********************************************************************//**
 *
 * tHg̐ݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::EnableFontFace(void)
{
	m_Fmt.dwMask	|= CFM_FACE;
}
/**********************************************************************//**
 *
 * tHg̐ݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::DisableFontFace(void)
{
	m_Fmt.dwMask	&= ~CFM_FACE;
}
/**********************************************************************//**
 *
 * tHg̐ݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat<_TN>::IsFontFace(void) const
{
	return (m_Fmt.dwMask & CFM_FACE) != 0;
}

/**********************************************************************//**
 *
 * tHgt@~ƃsb`ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= F
*//***********************************************************************/
template<typename _TN>
void ICharFormat<_TN>::SetPitchAndFamily(BYTE byPitchAndFamily)
{
	m_Fmt.bPitchAndFamily = byPitchAndFamily;
}
/**********************************************************************//**
 *
 * tHgt@~ƃsb`擾
 *
 ----------------------------------------------------------------------
 * @return	F
*//***********************************************************************/
template<typename _TN>
BYTE ICharFormat<_TN>::GetPitchAndFamily(void) const
{
	return m_Fmt.bPitchAndFamily;
}

// CHARFORMAT2NX
/**********************************************************************//**
 *
 * wiFݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= wiF
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetBackColor(COLORREF color)
{
	m_Fmt.crBackColor = color;
}
/**********************************************************************//**
 *
 * wiF擾
 *
 ----------------------------------------------------------------------
 * @return	wiF
*//***********************************************************************/
template<typename _TN>
COLORREF ICharFormat2<_TN>::GetBackColor(void) const
{
	return m_Fmt.crBackColor;
}
/**********************************************************************//**
 *
 * wiF̐ݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableBackColor(void)
{
	m_Fmt.dwMask	|= CFM_COLOR;
}
/**********************************************************************//**
 *
 * wiF̐ݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableBackColor(void)
{
	m_Fmt.dwMask	&= ~CFM_BACKCOLOR;
}
/**********************************************************************//**
 *
 * wiF̐ݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsBackColor(void) const
{
	return (m_Fmt.dwMask & CFM_BACKCOLOR) != 0;
}
/**********************************************************************//**
 *
 * wiFݒVXeJ[ɂ
 * (COLOR_WINDOWTEXTɂȂ)
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableAutoBackColor(void)
{
	m_Fmt.dwEffects |= CFE_AUTOBACKCOLOR;
}
/**********************************************************************//**
 *
 * wiFݒVXeJ[ɂ̂
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableAutoBackColor(void)
{
	m_Fmt.dwEffects &= ~CFE_AUTOBACKCOLOR;
}
/**********************************************************************//**
 *
 * wiFݒ肪VXeJ[ݒ肩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsAutoBackColor(void) const
{
	return ( (m_Fmt.dwMask & CFM_BACKCOLOR) && (m_Fmt.dwEffects & CFE_AUTOBACKCOLOR) );
}

/**********************************************************************//**
 *
 * tHg̑ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	byWeight	= tHg̑
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetWeight(WORD wWeight)
{
	m_Fmt.wWeight	= wWeight;
}
/**********************************************************************//**
 *
 * tHg̑擾
 *
 ----------------------------------------------------------------------
 * @return	tHg̑
*//***********************************************************************/
template<typename _TN>
WORD ICharFormat2<_TN>::GetWeight(void) const
{
	return m_Fmt.wWeight;
}
/**********************************************************************//**
 *
 * tHg̑ݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableWeight(void)
{
	m_Fmt.dwMask	|= CFM_WEIGHT;
}
/**********************************************************************//**
 *
 * tHg̑ݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableWeight(void)
{
	m_Fmt.dwMask	&= ~CFM_WEIGHT;
}
/**********************************************************************//**
 *
 * tHg̑ݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsWeight(void) const
{
	return (m_Fmt.dwMask & CFM_WEIGHT) != 0;
}

/**********************************************************************//**
 *
 * ̃^Cvݒ
 *
 ----------------------------------------------------------------------
 * @param	byUnderlineType	= ̃^Cv
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetUnderlineType(BYTE byUnderlineType)
{
	m_Fmt.bUnderlineType	= byUnderlineType;
}
/**********************************************************************//**
 *
 * ̃^Cv擾
 *
 ----------------------------------------------------------------------
 * @return	̃^Cv
*//***********************************************************************/
template<typename _TN>
BYTE ICharFormat2<_TN>::GetUnderlineType(void) const
{
	return m_Fmt.bUnderlineType;
}
/**********************************************************************//**
 *
 * ̃^CvݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableUnderlineType(void)
{
	m_Fmt.dwMask	|= CFM_UNDERLINETYPE;
}
/**********************************************************************//**
 *
 * ̃^Cvݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableUnderlineType(void)
{
	m_Fmt.dwMask	&= ~CFM_UNDERLINETYPE;
}
/**********************************************************************//**
 *
 * ̃^Cvݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsUnderlineType(void) const
{
	return (m_Fmt.dwMask & CFM_UNDERLINETYPE) != 0;
}

/**********************************************************************//**
 *
 * tHg̊ԊuݒiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @param [in]	bySpacing	= tHg̊Ԋu
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetSpacing(SHORT sSpacing)
{
	m_Fmt.sSpacing	= sSpacing;
}
/**********************************************************************//**
 *
 * tHg̊Ԋu擾iRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	tHg̊Ԋu
*//***********************************************************************/
template<typename _TN>
SHORT ICharFormat2<_TN>::GetSpacing(void) const
{
	return m_Fmt.sSpacing;
}
/**********************************************************************//**
 *
 * tHg̊ԊuݒLɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableSpacing(void)
{
	m_Fmt.dwMask	|= CFM_SPACING;
}
/**********************************************************************//**
 *
 * tHg̊Ԋuݒ𖳌ɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableSpacing(void)
{
	m_Fmt.dwMask	&= ~CFM_SPACING;
}
/**********************************************************************//**
 *
 * tHg̊Ԋuݒ肪LǂiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsSpacing(void) const
{
	return (m_Fmt.dwMask & CFM_SPACING) != 0;
}

/**********************************************************************//**
 *
 * [PIDݒiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @param [in]	lcid	= [PID
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetLCID(DWORD lcid)
{
	m_Fmt.lcid	= lcid;
}
/**********************************************************************//**
 *
 * [PID擾iRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	[PID
*//***********************************************************************/
template<typename _TN>
DWORD ICharFormat2<_TN>::GetLCID(void) const
{
	return m_Fmt.lcid;
}
/**********************************************************************//**
 *
 * [PIDݒLɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableLCID(void)
{
	m_Fmt.dwMask	|= CFM_SPACING;
}
/**********************************************************************//**
 *
 * [PIDݒ𖳌ɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableLCID(void)
{
	m_Fmt.dwMask	&= ~CFM_SPACING;
}
/**********************************************************************//**
 *
 * [PIDݒ肪LǂiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsLCID(void) const
{
	return (m_Fmt.dwMask & CFM_SPACING) != 0;
}

/**********************************************************************//**
 *
 * X^CݒiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @param [in]	lcid	= X^C
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetCharStyle(SHORT sStyle)
{
	m_Fmt.sStyle = sStyle;
}
/**********************************************************************//**
 *
 * X^C擾iRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	X^C
*//***********************************************************************/
template<typename _TN>
SHORT ICharFormat2<_TN>::GetCharStyle(void) const
{
	return m_Fmt.sStyle;
}
/**********************************************************************//**
 *
 * X^CݒLɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableCharStyle(void)
{
	m_Fmt.dwMask	|= CFM_STYLE;
}
/**********************************************************************//**
 *
 * X^Cݒ𖳌ɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableCharStyle(void)
{
	m_Fmt.dwMask	&= ~CFM_STYLE;
}
/**********************************************************************//**
 *
 * X^Cݒ肪LǂiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsCharStyle(void) const
{
	return (m_Fmt.dwMask & CFM_STYLE) != 0;
}

/**********************************************************************//**
 *
 * J[jOݒiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @param	wKerning	= J[jO
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::SetKerning(WORD wKerning)
{
	m_Fmt.wKerning = wKerning;
}
/**********************************************************************//**
 *
 * J[jO擾iRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	J[jO
*//***********************************************************************/
template<typename _TN>
WORD ICharFormat2<_TN>::GetKerning(void) const
{
	return m_Fmt.wKerning;
}
/**********************************************************************//**
 *
 * J[jOݒLɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::EnableKerning(void)
{
	m_Fmt.dwMask	|= CFM_KERNING;
}
/**********************************************************************//**
 *
 * J[jOݒ𖳌ɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void ICharFormat2<_TN>::DisableKerning(void)
{
	m_Fmt.dwMask	&= ~CFM_KERNING;
}
/**********************************************************************//**
 *
 * J[jOݒ肪LǂiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool ICharFormat2<_TN>::IsKerning(void) const
{
	return (m_Fmt.dwMask & CFM_KERNING) != 0;
}

// ^̎̉
template class ICharFormat<CHARFORMATA>;
template class ICharFormat<CHARFORMATW>;
template class ICharFormat<CHARFORMAT2A>;
template class ICharFormat<CHARFORMAT2W>;
template class ICharFormat2<CHARFORMAT2A>;
template class ICharFormat2<CHARFORMAT2W>;

// PARAFORMATNX
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename _TN>
IParaFormat<_TN>::IParaFormat(void)
{
	ZeroMemory(&m_Fmt, sizeof(Format));
	m_Fmt.cbSize = sizeof(Format);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	rFormat	= CHARFORMAT
*//***********************************************************************/
template<typename _TN>
IParaFormat<_TN>::IParaFormat(const Format& rFormat)
{
	memcpy(&m_Fmt, &rFormat, sizeof(Format));
	m_Fmt.cbSize = sizeof(Format);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename _TN>
IParaFormat<_TN>::~IParaFormat(void)
{
}

/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lIndent	= w肳ꂽi̍ŏ̍s̃Cfg
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetStartIndent(LONG lIndent)
{
	m_Fmt.dxStartIndent = lIndent;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfg擾
 *
 ----------------------------------------------------------------------
 * @return	w肳ꂽi̍ŏ̍s̃Cfg
*//***********************************************************************/
template<typename _TN>
LONG IParaFormat<_TN>::GetStartIndent(void) const
{
	return m_Fmt.dxStartIndent;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableStartIndent(void)
{
	m_Fmt.dwMask	|= PFM_STARTINDENT;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒi΁j𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableStartIndent(void)
{
	m_Fmt.dwMask	&= ~PFM_STARTINDENT;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsStartIndent(void) const
{
	return (m_Fmt.dwMask & PFM_STARTINDENT) != 0;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableOffsetIndent(void)
{
	m_Fmt.dwMask	|= PFM_OFFSETINDENT;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒi΁j𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableOffsetIndent(void)
{
	m_Fmt.dwMask	&= ~PFM_OFFSETINDENT;
}
/**********************************************************************//**
 *
 * w肳ꂽi̍ŏ̍s̃Cfgݒi΁jLǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsOffsetIndent(void) const
{
	return (m_Fmt.dwMask & PFM_OFFSETINDENT) != 0;
}

/**********************************************************************//**
 *
 * w肳ꂽỉẼCfgݒ
 *
 ----------------------------------------------------------------------
 * @param	lIndent	= w肳ꂽỉẼCfg
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetRightIndent(LONG lIndent)
{
	m_Fmt.dxRightIndent = lIndent;
}
/**********************************************************************//**
 *
 * w肳ꂽỉẼCfg擾
 *
 ----------------------------------------------------------------------
 * @return	w肳ꂽỉẼCfg
*//***********************************************************************/
template<typename _TN>
LONG IParaFormat<_TN>::GetRightIndent(void) const
{
	return m_Fmt.dxRightIndent;
}
/**********************************************************************//**
 *
 * w肳ꂽỉẼCfgݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableRightIndent(void)
{
	m_Fmt.dwMask	|= PFM_RIGHTINDENT;
}
/**********************************************************************//**
 *
 * w肳ꂽỉẼCfgݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableRightIndent(void)
{
	m_Fmt.dwMask	&= ~PFM_RIGHTINDENT;
}
/**********************************************************************//**
 *
 * w肳ꂽỉẼCfgݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsRightIndent(void) const
{
	return (m_Fmt.dwMask & PFM_RIGHTINDENT) != 0;
}

/**********************************************************************//**
 *
 * 2sڈȍ~̍s̃Cfgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lOffset	= 2sڈȍ~̍s̃Cfg
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetOffset(LONG lOffset)
{
	m_Fmt.dxOffset = lOffset;
}
/**********************************************************************//**
 *
 * 2sڈȍ~̍s̃Cfg擾
 *
 ----------------------------------------------------------------------
 * @return	2sڈȍ~̍s̃Cfg
*//***********************************************************************/
template<typename _TN>
LONG IParaFormat<_TN>::GetOffset(void) const
{
	return m_Fmt.dxOffset;
}
/**********************************************************************//**
 *
 * 2sڈȍ~̍s̃CfgݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableOffset(void)
{
	m_Fmt.dwMask	|= PFM_OFFSET;
}
/**********************************************************************//**
 *
 * 2sڈȍ~̍s̃Cfgݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableOffset(void)
{
	m_Fmt.dwMask	&= ~PFM_OFFSET;
}
/**********************************************************************//**
 *
 * 2sڈȍ~̍s̃Cfgݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsOffset(void) const
{
	return (m_Fmt.dwMask & PFM_OFFSET) != 0;
}

/**********************************************************************//**
 *
 * i̔zuݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	wAlignment	= i̔zu
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetAlignment(WORD wAlignment)
{
	m_Fmt.wAlignment = wAlignment;
}
/**********************************************************************//**
 *
 * i̔zu擾
 *
 ----------------------------------------------------------------------
 * @return	i̔zu
*//***********************************************************************/
template<typename _TN>
WORD IParaFormat<_TN>::GetAlignment(void) const
{
	return m_Fmt.wAlignment;
}
/**********************************************************************//**
 *
 * i̔zuݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableAlignment(void)
{
	m_Fmt.dwMask	|= PFM_ALIGNMENT;
}
/**********************************************************************//**
 *
 * i̔zuݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableAlignment(void)
{
	m_Fmt.dwMask	&= ~PFM_ALIGNMENT;
}
/**********************************************************************//**
 *
 * i̔zuݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsAlignment(void) const
{
	return (m_Fmt.dwMask & PFM_ALIGNMENT) != 0;
}

/**********************************************************************//**
 *
 * ^uXgbv̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	wAlignment	= ^uXgbv̐
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetTabCount(SHORT sTabCount)
{
	m_Fmt.cTabCount = sTabCount;
}
/**********************************************************************//**
 *
 * ^uXgbv̐擾
 *
 ----------------------------------------------------------------------
 * @return	^uXgbv̐
*//***********************************************************************/
template<typename _TN>
SHORT IParaFormat<_TN>::GetTabCount(void) const
{
	return m_Fmt.cTabCount;
}
/**********************************************************************//**
 *
 * ^uXgbv̈ʒuݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= CfbNX
 * @param [in]	lPos	= ^uXgbv̈ʒu
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetTabPos(int nIndex, LONG lPos)
{
	if( nIndex < 0 || nIndex >= MAX_TAB_STOPS ) return;
	m_Fmt.rgxTabs[nIndex] = lPos;
}
/**********************************************************************//**
 *
 * ^uXgbv̈ʒu擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= CfbNX
 * @return	^uXgbv̈ʒu
*//***********************************************************************/
template<typename _TN>
LONG IParaFormat<_TN>::GetTabPos(int nIndex) const
{
	if( nIndex < 0 || nIndex >= MAX_TAB_STOPS ) return -1;
	return m_Fmt.rgxTabs[nIndex];
}
/**********************************************************************//**
 *
 * ^uXgbvݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableTabStops(void)
{
	m_Fmt.dwMask	|= PFM_TABSTOPS;
}
/**********************************************************************//**
 *
 * ^uXgbvݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableTabStops(void)
{
	m_Fmt.dwMask	&= ~PFM_TABSTOPS;
}
/**********************************************************************//**
 *
 * ^uXgbvݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsTabStops(void) const
{
	return (m_Fmt.dwMask & PFM_TABSTOPS) != 0;
}

/**********************************************************************//**
 *
 * ioOIvVݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	wNumbering	= ioOIvV
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetNumbering(WORD wNumbering)
{
	m_Fmt.wNumbering = wNumbering;
}
/**********************************************************************//**
 *
 * ioOIvV擾
 *
 ----------------------------------------------------------------------
 * @return	ioOIvV
*//***********************************************************************/
template<typename _TN>
WORD IParaFormat<_TN>::GetNumbering(void) const
{
	return m_Fmt.wNumbering;
}
/**********************************************************************//**
 *
 * ioOIvVݒLɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableNumbering(void)
{
	m_Fmt.dwMask	|= PFM_NUMBERING;
}
/**********************************************************************//**
 *
 * ioOIvVݒ𖳌ɂ
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableNumbering(void)
{
	m_Fmt.dwMask	&= ~PFM_NUMBERING;
}
/**********************************************************************//**
 *
 * ioOIvVݒ肪Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsNumbering(void) const
{
	return (m_Fmt.dwMask & PFM_NUMBERING) != 0;
}

/**********************************************************************//**
 *
 * ǐʂݒiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @param [in]	wRtlPara	= ǐ
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::SetRtlPara(WORD wRtlPara)
{
	m_Fmt.wEffects = wRtlPara;
}
/**********************************************************************//**
 *
 * ǐʂ擾iRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	ǐ
*//***********************************************************************/
template<typename _TN>
WORD IParaFormat<_TN>::GetRtlPara(void) const
{
	return m_Fmt.wEffects;
}
/**********************************************************************//**
 *
 * ǐʐݒLɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::EnableRtlPara(void)
{
	m_Fmt.dwMask	|= PFM_RTLPARA;
}
/**********************************************************************//**
 *
 * ǐʐݒ𖳌ɂiRg[ɂ\ɉeȂj
 *
*//***********************************************************************/
template<typename _TN>
void IParaFormat<_TN>::DisableRtlPara(void)
{
	m_Fmt.dwMask	&= ~PFM_RTLPARA;
}
/**********************************************************************//**
 *
 * ǐʐݒ肪LǂiRg[ɂ\ɉeȂj
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<typename _TN>
bool IParaFormat<_TN>::IsRtlPara(void) const
{
	return (m_Fmt.dwMask & PFM_RTLPARA) != 0;
}

// ^̎̉
template class IParaFormat<PARAFORMAT>;
template class IParaFormat<PARAFORMAT2>;
template class IParaFormat2<PARAFORMAT2>;

}	// end of namespace wx
}	// end of namespace iris
