//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFloatSpin.h
 * @brief		XsRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFloatSpin_H_
#define INCG_IRIS_WXFloatSpin_H_

//======================================================================
// include
#include "WXSpin.h"

namespace iris {
namespace wx
{

//======================================================================
// class

//! XsRg[
class CFSpin : public CSpin
{
private:
	// ݂̈ʒu
	float	m_fPos;
	float	m_fDelta;
	// x
	float	m_fMin, m_fMax;
	// \
	int		m_Digit;
public:
	// RXgN^
	CFSpin(void);
	CFSpin(HWND hWnd);
	// fXgN^
	~CFSpin(void);
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
private:
	// BODYɃeLXgݒ
	void		SetText(void);
	// BODY琔l擾
	void		GetText(void);

public:
	// set, get
	void		SetDigit(int digit)		{ m_Digit = digit; }
	int			GetDigit(void)	const	{ return m_Digit; }

	// 
	void		SetDelta(float delta)	{ m_fDelta = delta; }
	float		GetDelta(void)	const	{ return m_fDelta; }

public:
	// wrap
	// ʒuݒ
	float		SetFPos(float pos);
	// ʒu擾
	float		GetFPos(void) const;
	// ͈͐ݒ
	void		SetFRange(float fmin, float fmax);
	// ͈͎擾
	void		GetFRange(float& fmin, float& fmax) const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
