//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindWindows.cpp
 * @brief		FindWindows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindWindows_CPP_

//======================================================================
// include
#include "WXFindWindows.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * EBhE񋓊֐
 *
 -----------------------------------------------------------------------
 * @param [in]	hWndParent			= EBhE
 * @param [in]	lpEnumFunc			= R[obN֐
 * @param [in]	lpszClassName		= NX
 * @param [in]	lpszWindowName		= EBhE
 * @param [in]	lParam				= [U[f[^
 * @return 
*//***********************************************************************/
BOOL	EnumFindWindows (HWND hWndParent, WNDENUMPROC lpEnumFunc, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, LPARAM lParam)
{
#ifdef UNICODE
	return EnumFindWindowsW(hWndParent, lpEnumFunc, lpszClassName, lpszWindowName, lParam);
#else
	return EnumFindWindowsA(hWndParent, lpEnumFunc, lpszClassName, lpszWindowName, lParam);
#endif
}
BOOL	EnumFindWindowsA(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPCSTR  lpszClassName, LPCSTR  lpszWindowName, LPARAM lParam)
{
	HWND hWnd = ::FindWindowExA(hWndParent, nullptr, lpszClassName, lpszWindowName);
	while( hWnd != nullptr )
	{
		if( !(*lpEnumFunc)(hWnd, lParam) ) return FALSE;
		if( !EnumFindWindowsA(hWnd, lpEnumFunc, lpszClassName, lpszWindowName, lParam) ) return FALSE;
		hWnd = ::FindWindowExA(hWndParent, hWnd, lpszClassName, lpszWindowName);
	}
	return TRUE;
}
BOOL	EnumFindWindowsW(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPCWSTR lpszClassName, LPCWSTR lpszWindowName, LPARAM lParam)
{
	HWND hWnd = ::FindWindowExW(hWndParent, nullptr, lpszClassName, lpszWindowName);
	while( hWnd != nullptr )
	{
		if( !(*lpEnumFunc)(hWnd, lParam) ) return FALSE;
		if( !EnumFindWindowsW(hWnd, lpEnumFunc, lpszClassName, lpszWindowName, lParam) ) return FALSE;
		hWnd = ::FindWindowExW(hWndParent, hWnd, lpszClassName, lpszWindowName);
	}
	return TRUE;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindWindows::CFindWindows(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindWindows::~CFindWindows(void)
{
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void CFindWindows::Update(void)
{
	m_Map.clear();
	EnumFindWindows(m_hParent, _EnumChildWindowsProc, nullptr, nullptr, reinterpret_cast<LPARAM>(this));
}

}	// end of namespace wx
}	// end of namespace iris
