//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXScrollBar.cpp
 * @brief		XN[o[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXScrollBar_CPP_
//======================================================================
// include
#include "WXScrollBar.h"
#include <commctrl.h>
#include <windowsx.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CScrollBar::CScrollBar(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CScrollBar::CScrollBar(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CScrollBar::~CScrollBar(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CScrollBar::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_SCROLLBAR
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CScrollBar::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_SCROLLBAR
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CScrollBar::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_SCROLLBAR
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CScrollBar::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_SCROLLBAR
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CScrollBar::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
BOOL	CScrollBar::EnableArrow(DWORD dwFlags)
{
#if	!defined(IRIS_WIN32_WCE)
	return IRIS_TO_BOOL(SendMessage(SBM_ENABLE_ARROWS, dwFlags, 0));
#else
	return FALSE;
#endif
}
int		CScrollBar::SetPos(int pos, BOOL redraw)
{
#if	!defined(IRIS_WIN32_WCE)
	return static_cast<int>(SendMessage(SBM_SETPOS, pos, redraw));
#else
	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_POS;
	si.nPos = pos;
	SetInfo(&si, redraw);
	return si.nPos;
#endif
}
int		CScrollBar::GetPos(void)	const
{
#if	!defined(IRIS_WIN32_WCE)
	return static_cast<int>(SendMessage(SBM_GETPOS, 0, 0));
#else
	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_POS;
	GetInfo(&si);
	return si.nPos;
#endif
}
void	CScrollBar::SetRange(int min, int max, BOOL redraw)
{
#if	!defined(IRIS_WIN32_WCE)
	SendMessage(redraw ? SBM_SETRANGEREDRAW : SBM_SETRANGE, min, max);
#else
	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_RANGE;
	si.nMin = min;
	si.nMax = max;
	SetInfo(&si, redraw);
#endif
}
void	CScrollBar::SetRange(int min, int max)
{
#if	!defined(IRIS_WIN32_WCE)
	SendMessage(SBM_SETRANGE, min, max);
#else
	SetRange(min, max, FALSE);
#endif
}
void	CScrollBar::SetRangeRedraw(int min, int max)
{
#if	!defined(IRIS_WIN32_WCE)
	SendMessage(SBM_SETRANGEREDRAW, min, max);
#else
	SetRange(min, max, TRUE);
#endif
}
void	CScrollBar::GetRange(int* min, int* max) const
{
#if	!defined(IRIS_WIN32_WCE)
	SendMessage(SBM_GETRANGE, reinterpret_cast<WPARAM>(min), reinterpret_cast<LPARAM>(max));
#else
	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_RANGE;
	GetInfo(&si);
	if( min != nullptr ) *min = si.nMin;
	if( max != nullptr ) *max = si.nMax;
#endif
}
#if	!defined(IRIS_WIN32_WCE)
BOOL	CScrollBar::GetBarInfo(LPSCROLLBARINFO lpsbi) const
{
#if	(_WIN32_WINNT >= 0x0501)
	return IRIS_TO_BOOL(SendMessage(SBM_GETSCROLLBARINFO, 0, reinterpret_cast<LPARAM>(lpsbi)));
#else
	return FALSE;
#endif
}
#endif
BOOL	CScrollBar::SetInfo(LPCSCROLLINFO lpsi, BOOL redraw)
{
	return IRIS_TO_BOOL(SendMessage(SBM_SETSCROLLINFO, redraw, reinterpret_cast<LPARAM>(lpsi)));
}
BOOL	CScrollBar::GetInfo(LPSCROLLINFO lpsi) const
{
	return IRIS_TO_BOOL(SendMessage(SBM_GETSCROLLINFO, 0, reinterpret_cast<LPARAM>(lpsi)));
}
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
