//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRebar.cpp
 * @brief		o[Rg[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXRebar_CPP_

//======================================================================
// include
#include "WXRebar.h"
#include "../WXComControl.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * RB_BEGINDRAG
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= hbO Ah hbvΏۂ̃oh̃CfbNX 
 * @param [in]	dwPos	= }EX̊JnW(-1:Rg[̃Xbh GetMessage ܂ PeekMessage OĂяoƂ̃}EXʒu)
*//***********************************************************************/
void		Rebar_BeginDrag(HWND hWnd, UINT uIndex, DWORD dwPos)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, RB_BEGINDRAG, (WPARAM)uIndex, (LPARAM)dwPos);
#endif
}
/**********************************************************************//**
 *
 * oh̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @return	
*//***********************************************************************/
BOOL		Rebar_DeleteBand(HWND hWnd, UINT uIndex)
{
	return (BOOL)SendMessage(hWnd, RB_DELETEBAND, (WPARAM)uIndex, 0);
}
/**********************************************************************//**
 *
 * V}EXWw
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	dwPos	= }EX̊JnW(-1:Rg[̃Xbh GetMessage ܂ PeekMessage OĂяoƂ̃}EXʒu)
*//***********************************************************************/
void		Rebar_DragMove(HWND hWnd, DWORD dwPos)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, RB_DRAGMOVE, 0, (LPARAM)dwPos);
#endif
}
/**********************************************************************//**
 *
 * hbȌI
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
*//***********************************************************************/
void		Rebar_EndDrag(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, RB_ENDDRAG, 0, 0);
#endif
}
/**********************************************************************//**
 *
 * ohE̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [out]	lprc	= E
*//***********************************************************************/
void		Rebar_GetBandBorders(HWND hWnd, UINT uIndex, LPRECT lprc)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, RB_GETBANDBORDERS, (WPARAM)uIndex, (LPARAM)lprc);
#endif
}
/**********************************************************************//**
 *
 * oh̐擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	oh̐
*//***********************************************************************/
UINT		Rebar_GetBandCount(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, RB_GETBANDCOUNT, 0, 0);
}
/**********************************************************************//**
 *
 * oh擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [out]	lprbi	= óBoh
 * @return	
*//***********************************************************************/
BOOL		Rebar_GetBandInfo (HWND hWnd, UINT uIndex, LPREBARBANDINFO	lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_GETBANDINFO , (WPARAM)uIndex, (LPARAM)lprbi);
}
/// iris::wx::Rebar_GetBandInfo Q
BOOL		Rebar_GetBandInfoA(HWND hWnd, UINT uIndex, LPREBARBANDINFOA lprbi)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, RB_GETBANDINFOA, (WPARAM)uIndex, (LPARAM)lprbi);
#else
	return FALSE;
#endif
}
/// iris::wx::Rebar_GetBandInfo Q
BOOL		Rebar_GetBandInfoW(HWND hWnd, UINT uIndex, LPREBARBANDINFOW lprbi)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, RB_GETBANDINFOW, (WPARAM)uIndex, (LPARAM)lprbi);
#else
	return FALSE;
#endif
}
/**********************************************************************//**
 *
 * oh̃}[W擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [out]	lpMargins	= o
*//***********************************************************************/
void		Rebar_GetBandMargins(HWND hWnd, LPARAM lpMargins)
{
#if (_WIN32_WINNT >= 0x501)
	SendMessage(hWnd, RB_GETBANDMARGINS, 0, lpMargins);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(lpMargins);
#endif
}
/**********************************************************************//**
 *
 * o[̍擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	o[̍
*//***********************************************************************/
UINT		Rebar_GetBarHeight(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (UINT)SendMessage(hWnd, RB_GETBARHEIGHT, 0, 0);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return	0;
#endif
}
/**********************************************************************//**
 *
 * o[̏擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	lpri	= o[
 * @return	
*//***********************************************************************/
BOOL		Rebar_GetBarInfo(HWND hWnd, LPREBARINFO lpri)
{
	return (BOOL)SendMessage(hWnd, RB_GETBARINFO, 0, (LPARAM)lpri);
}
/**********************************************************************//**
 *
 * wiF̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	wiF
*//***********************************************************************/
COLORREF	Rebar_GetBkColor(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, RB_GETBKCOLOR, 0, 0);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return 0xFFFFFFFF;
#endif
}
/**********************************************************************//**
 *
 * Rg[̔zF擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [out]	lpClrScheme	= zF
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL		Rebar_GetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme)
{
	return ComControl_GetColorScheme(hWnd, lpClrScheme);
}
#endif
/**********************************************************************//**
 *
 * RB_GETDROPTARGET
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= Ώۂ̃EBhEnh
 * @param [out]	lpDropTarget	= 
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
void		Rebar_GetDropTarget(HWND hWnd, IDropTarget** lpDropTarget)
{
	ComControl_GetDropTarget(hWnd, lpDropTarget);
}
#endif
/**********************************************************************//**
 *
 * ݂̃pbg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	pbgnh
*//***********************************************************************/
HPALETTE	Rebar_GetPalette(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400) && !defined(IRIS_WIN32_WCE)
	return (HPALETTE)SendMessage(hWnd, RB_GETPALETTE, 0, 0);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * oh̋E擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [out]	lprc	= o
 * @return	
*//***********************************************************************/
BOOL		Rebar_GetRect(HWND hWnd, UINT uIndex, LPRECT lprc)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, RB_GETRECT, (WPARAM)uIndex, (LPARAM)lprc);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(uIndex);
	IRIS_UNUSED_VARIABLE(lprc);
	return FLASE;
#endif
}
/**********************************************************************//**
 *
 * oh̍s擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	s
*//***********************************************************************/
UINT		Rebar_GetRowCount(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, RB_GETROWCOUNT, 0, 0);
}
/**********************************************************************//**
 *
 * oh̍擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @return	
*//***********************************************************************/
UINT		Rebar_GetRowHeight(HWND hWnd, UINT uIndex)
{
	return (UINT)SendMessage(hWnd, RB_GETROWHEIGHT, (WPARAM)uIndex, 0);
}
/**********************************************************************//**
 *
 * eLXgF̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	eLXgF
*//***********************************************************************/
COLORREF	Rebar_GetTextColor(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, RB_GETTEXTCOLOR, 0, 0);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return 0;
#endif
}
/**********************************************************************//**
 *
 * c[`bvEBhE̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	c[`bvEBhẼnh
*//***********************************************************************/
HWND		Rebar_GetToolTips(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400) && !defined(IRIS_WIN32_WCE)
	return (HWND)SendMessage(hWnd, RB_GETTOOLTIPS, 0, 0);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * RB_GETUNICODEFORMAT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	
*//***********************************************************************/
BOOL		Rebar_GetUnicodeFormat(HWND hWnd)
{
	return ComConrtol_GetUnicodeFormat(hWnd);
}
/**********************************************************************//**
 *
 * qbgeXg
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lprhi	= 
 * @return	
*//***********************************************************************/
int			Rebar_HitTest(HWND hWnd, LPRBHITTESTINFO lprhi)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage(hWnd, RB_HITTEST, 0, (LPARAM)lprhi);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return -1;
#endif
}
/**********************************************************************//**
 *
 * ohIDCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uBandID	= ohID
 * @return	oh̃CfbNX
*//***********************************************************************/
int			Rebar_IDToIndex(HWND hWnd, UINT uBandID)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage(hWnd, RB_IDTOINDEX, (WPARAM)uBandID, 0);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(uBandID);
	return -1;
#endif
}
/**********************************************************************//**
 *
 * oh̑}
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [in]	lprbi	= oh̏
 * @return	
*//***********************************************************************/
BOOL		Rebar_InsertBand (HWND hWnd, UINT uIndex, LPREBARBANDINFO  lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_INSERTBAND , (WPARAM)uIndex, (LPARAM)lprbi);
}
/// iris::wx::Rebar_InsertBand Q
BOOL		Rebar_InsertBandA(HWND hWnd, UINT uIndex, LPREBARBANDINFOA lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_INSERTBANDA, (WPARAM)uIndex, (LPARAM)lprbi);
}
/// iris::wx::Rebar_InsertBand Q
BOOL		Rebar_InsertBandW(HWND hWnd, UINT uIndex, LPREBARBANDINFOW lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_INSERTBANDW, (WPARAM)uIndex, (LPARAM)lprbi);
}
/**********************************************************************//**
 *
 * ohő剻
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [in]	bIdel	= 
*//***********************************************************************/
void		Rebar_MaximizeBand(HWND hWnd, UINT uIndex, BOOL bIdel)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, RB_MAXIMIZEBAND, (WPARAM)uIndex, (LPARAM)bIdel);
#endif
}
/**********************************************************************//**
 *
 * ohŏ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
*//***********************************************************************/
void		Rebar_MinimizeBand(HWND hWnd, UINT uIndex)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, RB_MINIMIZEBAND, (WPARAM)uIndex, 0);
#endif
}
/**********************************************************************//**
 *
 * ohړ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uFrom	= ړoh̃CfbNX
 * @param [in]	uTo		= ړ̃oh̃CfbNX
 * @return	
*//***********************************************************************/
BOOL		Rebar_MoveBand(HWND hWnd, UINT uFrom, UINT uTo)
{
#if (_WIN32_IE >= 0x0400) && !defined(IRIS_WIN32_WCE)
	return (BOOL)SendMessage(hWnd, RB_MOVEBAND, (WPARAM)uFrom, (LPARAM)uTo);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(uFrom);
	IRIS_UNUSED_VARIABLE(uTo);
	return FALSE;
#endif
}
/**********************************************************************//**
 *
 * VFuvbV
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	uIndex		= oh̃CfbNX
 * @param [in]	lAppValue	= 
*//***********************************************************************/
void		Rebar_PushChevron(HWND hWnd, UINT uIndex, LPARAM lAppValue)
{
#if (_WIN32_IE >= 0x0400) && !defined(IRIS_WIN32_WCE)
	SendMessage(hWnd, RB_PUSHCHEVRON, (WPARAM)uIndex, lAppValue);
#endif
}
/**********************************************************************//**
 *
 * oh擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [in]	lprbi	= oh
 * @return	
*//***********************************************************************/
BOOL		Rebar_SetBandInfo (HWND hWnd, UINT uIndex, LPREBARBANDINFO	lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_SETBANDINFO , (WPARAM)uIndex, (LPARAM)lprbi);
}
/// iris::wx::Rebar_SetBandInfo Q
BOOL		Rebar_SetBandInfoA(HWND hWnd, UINT uIndex, LPREBARBANDINFOA lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_SETBANDINFOA, (WPARAM)uIndex, (LPARAM)lprbi);
}
/// iris::wx::Rebar_SetBandInfo Q
BOOL		Rebar_SetBandInfoW(HWND hWnd, UINT uIndex, LPREBARBANDINFOW lprbi)
{
	return (BOOL)SendMessage(hWnd, RB_SETBANDINFOW, (WPARAM)uIndex, (LPARAM)lprbi);
}
/**********************************************************************//**
 *
 * o[̏擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpri	= o[
 * @return	
*//***********************************************************************/
BOOL		Rebar_SetBarInfo(HWND hWnd, LPREBARINFO lpri)
{
	return (BOOL)SendMessage(hWnd, RB_SETBARINFO, 0, (LPARAM)lpri);
}
/**********************************************************************//**
 *
 * wiF̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= VF
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	Rebar_SetBkColor(HWND hWnd, COLORREF color)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, RB_SETBKCOLOR, 0, (LPARAM)color);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(color);
	return 0xFFFFFFFF;
#endif
}
/**********************************************************************//**
 *
 * Rg[̔zFݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	lpClrScheme	= zF
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
void		Rebar_SetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme)
{
	ComControl_SetColorScheme(hWnd, lpClrScheme);
}
#endif
/**********************************************************************//**
 *
 * pbg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	hPalette	= Vpbg
 * @return	ȑÕpbg
*//***********************************************************************/
HPALETTE	Rebar_SetPalette(HWND hWnd, HPALETTE hPalette)
{
#if (_WIN32_IE >= 0x0400) && !defined(IRIS_WIN32_WCE)
	return (HPALETTE)SendMessage(hWnd, RB_SETPALETTE, 0, (LPARAM)hPalette);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(hPalette);
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * RB_SETPARENT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	hPalette	= VI[i[nh
 * @return	ȑÕI[i[nh
*//***********************************************************************/
HWND		Rebar_SetParent(HWND hWnd, HWND hParent)
{
	return (HWND)SendMessage(hWnd, RB_SETPARENT, (WPARAM)hParent, 0);
}
/**********************************************************************//**
 *
 * eLXgF̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= VF
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	Rebar_SetTextColor(HWND hWnd, COLORREF color)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, RB_SETTEXTCOLOR, 0, (LPARAM)color);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(color);
	return 0;
#endif
}
/**********************************************************************//**
 *
 * c[`bvEBhE̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= VF
 * @return	ȑO̐F
*//***********************************************************************/
void		Rebar_SetToolTips(HWND hWnd, HWND hWndTT)
{
#if (_WIN32_IE >= 0x0400) && !defined(IRIS_WIN32_WCE)
	SendMessage(hWnd, RB_SETTOOLTIPS, (WPARAM)hWndTT, 0);
#endif
}
/**********************************************************************//**
 *
 * RB_SETUNICODEFORMAT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bUnicode	= 
 * @return	ȑO̒l
*//***********************************************************************/
BOOL		Rebar_SetUnicodeFormat(HWND hWnd, BOOL bUnicode)
{
	return ComControl_SetUnicodeFormat(hWnd, bUnicode);
}
/**********************************************************************//**
 *
 * RB_SETWINDOWTHEME
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT		Rebar_SetWindowTheme(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return ComControl_SetWindowTheme(hWnd, wParam, lParam);
}
/**********************************************************************//**
 *
 * oh̕\E\ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= oh̃CfbNX
 * @param [in]	bShow	= oh\邩\ɂ邩
 * @return	
*//***********************************************************************/
BOOL		Rebar_ShowBand(HWND hWnd, UINT uIndex, BOOL bShow)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, RB_SHOWBAND, (WPARAM)uIndex, (LPARAM)bShow);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(uIndex);
	IRIS_UNUSED_VARIABLE(bShow);
	return FALSE;
#endif
}
/**********************************************************************//**
 *
 * RB_SIZETORECT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	uIndex	= TCY킹̈
 * @return	
*//***********************************************************************/
BOOL		Rebar_SizeToRect(HWND hWnd, LPRECT lprc)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, RB_SIZETORECT, 0, (LPARAM)lprc);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(lprc);
	return FALSE;
#endif
}

//======================================================================
// class
// CToolBar
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRebar::CRebar(void)
{
	CComCtrl::Initialize(ICC_COOL_CLASSES);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CRebar::CRebar(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_COOL_CLASSES);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRebar::~CRebar(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRebar::Create( DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::Create(REBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRebar::Create( DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindow(REBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRebar::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::CreateEx(dwExStyle
		, REBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRebar::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindowEx(dwExStyle
		, REBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
void		CRebar::BeginDrag(UINT uIndex, DWORD dwPos)					{ return Rebar_BeginDrag(m_hWnd, uIndex, dwPos); }
BOOL		CRebar::DeleteBand(UINT uIndex)								{ return Rebar_DeleteBand(m_hWnd, uIndex); }
void		CRebar::DragMove(DWORD dwPos)								{ return Rebar_DragMove(m_hWnd, dwPos); }
void		CRebar::EndDrag(void)										{ return Rebar_EndDrag(m_hWnd); }
void		CRebar::GetBandBorders(UINT uIndex, LPRECT lprc)			const	{ return Rebar_GetBandBorders(m_hWnd, uIndex, lprc); }
UINT		CRebar::GetBandCount(void)									const	{ return Rebar_GetBandCount(m_hWnd); }
template<>
BOOL		CRebar::GetBandInfo<LPREBARBANDINFOA>(UINT uIndex, LPREBARBANDINFOA lprbi)	const	{ return Rebar_GetBandInfoA(m_hWnd, uIndex, lprbi); }
template<>
BOOL		CRebar::GetBandInfo<LPREBARBANDINFOW>(UINT uIndex, LPREBARBANDINFOW lprbi)	const	{ return Rebar_GetBandInfoW(m_hWnd, uIndex, lprbi); }
void		CRebar::GetBandMargins(LPARAM lpMargins)					const	{ return Rebar_GetBandMargins(m_hWnd, lpMargins); }
UINT		CRebar::GetBarHeight(void)									const	{ return Rebar_GetBarHeight(m_hWnd); }
BOOL		CRebar::GetBarInfo(LPREBARINFO lpri)						const	{ return Rebar_GetBarInfo(m_hWnd, lpri); }
COLORREF	CRebar::GetBkColor(void)									const	{ return Rebar_GetBkColor(m_hWnd); }
#if	 !defined(IRIS_WIN32_WCE)
BOOL		CRebar::GetColorScheme(LPCOLORSCHEME lpClrScheme)			const	{ return Rebar_GetColorScheme(m_hWnd, lpClrScheme); }
void		CRebar::GetDropTarget(IDropTarget** lpDropTarget)			const	{ return Rebar_GetDropTarget(m_hWnd, lpDropTarget); }
#endif
HPALETTE	CRebar::GetPalette(void)									const	{ return Rebar_GetPalette(m_hWnd); }
BOOL		CRebar::GetRect(UINT uIndex, LPRECT lprc)					const	{ return Rebar_GetRect(m_hWnd, uIndex, lprc); }
UINT		CRebar::GetRowCount(void)									const	{ return Rebar_GetRowCount(m_hWnd); }
UINT		CRebar::GetRowHeight(UINT uIndex)							const	{ return Rebar_GetRowHeight(m_hWnd, uIndex); }
COLORREF	CRebar::GetTextColor(void)									const	{ return Rebar_GetTextColor(m_hWnd); }
HWND		CRebar::GetToolTips(void)									const	{ return Rebar_GetToolTips(m_hWnd); }
BOOL		CRebar::GetUnicodeFormat(void)								const	{ return Rebar_GetUnicodeFormat(m_hWnd); }
int			CRebar::HitTest(LPRBHITTESTINFO lprhi)						{ return Rebar_HitTest(m_hWnd, lprhi); }
int			CRebar::IDToIndex(UINT uBandID)								{ return Rebar_IDToIndex(m_hWnd, uBandID); }
template<>
BOOL		CRebar::InsertBand<LPREBARBANDINFOA>(UINT uIndex, LPREBARBANDINFOA lprbi)	{ return Rebar_InsertBandA(m_hWnd, uIndex, lprbi); }
template<>
BOOL		CRebar::InsertBand<LPREBARBANDINFOW>(UINT uIndex, LPREBARBANDINFOW lprbi)	{ return Rebar_InsertBandW(m_hWnd, uIndex, lprbi); }
void		CRebar::MaximizeBand(UINT uIndex, BOOL bIdel)				{ return Rebar_MaximizeBand(m_hWnd, uIndex, bIdel); }
void		CRebar::MinimizeBand(UINT uIndex)							{ return Rebar_MinimizeBand(m_hWnd, uIndex); }
BOOL		CRebar::MoveBand(UINT uFrom, UINT uTo)						{ return Rebar_MoveBand(m_hWnd, uFrom, uTo); }
void		CRebar::PushChevron(UINT uIndex, LPARAM lAppValue)			{ return Rebar_PushChevron(m_hWnd, uIndex, lAppValue); }
template<>
BOOL		CRebar::SetBandInfo<LPREBARBANDINFOA>(UINT uIndex, LPREBARBANDINFOA lprbi)	{ return Rebar_SetBandInfoA(m_hWnd, uIndex, lprbi); }
template<>
BOOL		CRebar::SetBandInfo<LPREBARBANDINFOW>(UINT uIndex, LPREBARBANDINFOW lprbi)	{ return Rebar_SetBandInfoW(m_hWnd, uIndex, lprbi); }
BOOL		CRebar::SetBarInfo(LPREBARINFO lpri)						{ return Rebar_SetBarInfo(m_hWnd, lpri); }
COLORREF	CRebar::SetBkColor(COLORREF color)							{ return Rebar_SetBkColor(m_hWnd, color); }
#if	 !defined(IRIS_WIN32_WCE)
void		CRebar::SetColorScheme(LPCOLORSCHEME lpClrScheme)			{ return Rebar_SetColorScheme(m_hWnd, lpClrScheme); }
#endif
HPALETTE	CRebar::SetPalette(HPALETTE hPalette)						{ return Rebar_SetPalette(m_hWnd, hPalette); }
HWND		CRebar::SetParent(HWND hParent)								{ return Rebar_SetParent(m_hWnd, hParent); }
COLORREF	CRebar::SetTextColor(COLORREF color)						{ return Rebar_SetTextColor(m_hWnd, color); }
void		CRebar::SetToolTips(HWND hWndTT)							{ return Rebar_SetToolTips(m_hWnd, hWndTT); }
BOOL		CRebar::SetUnicodeFormat(BOOL bUnicode)						{ return Rebar_SetUnicodeFormat(m_hWnd, bUnicode); }
LRESULT		CRebar::SetWindowTheme(WPARAM wParam, LPARAM lParam)		{ return Rebar_SetWindowTheme(m_hWnd, wParam, lParam); }
BOOL		CRebar::ShowBand(UINT uIndex, BOOL bShow)					{ return Rebar_ShowBand(m_hWnd, uIndex, bShow); }
BOOL		CRebar::SizeToRect(LPRECT lprc)								{ return Rebar_SizeToRect(m_hWnd, lprc); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
