//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProgressBar.cpp
 * @brief		ProgressBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXProgressBar_CPP_

//======================================================================
// include
#include "WXProgressBar.h"
#include "../WXComControl.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * ʒuw肵i߂
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nDelta	= i߂
 * @return	
*//***********************************************************************/
LRESULT		ProgressBar_DeltaPos(HWND hWnd, int nDelta)
{
	return SendMessage( hWnd, PBM_DELTAPOS, (WPARAM)nDelta, 0 );
}
/**********************************************************************//**
 *
 * ʒu擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ʒu
*//***********************************************************************/
int			ProgressBar_GetPos(HWND hWnd)
{
	return (int)SendMessage( hWnd, PBM_GETPOS, 0, 0 );
}
/**********************************************************************//**
 *
 * ͈͂̎擾
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	bLow	= 0:őlԂ, 0ȊO:ŏlԂ
 * @return	͈
*//***********************************************************************/
int			ProgressBar_GetRange(HWND hWnd, BOOL bLow)
{
	return (int)SendMessage( hWnd, PBM_GETRANGE, (WPARAM)bLow, 0 );
}
/**********************************************************************//**
 *
 * ͈͂̎擾
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	nLower	= ŏl
 * @param [out]	nUpper	= ől
*//***********************************************************************/
void		ProgressBar_GetRange(HWND hWnd, int& nLower, int& nUpper)
{
	PBRANGE range;
	SendMessage( hWnd, PBM_GETRANGE, 0, (LPARAM)&range );
	nLower = range.iLow;
	nUpper = range.iHigh;
}
/// ProgressBar_GetRange Q
/// ProgressBar_GetRange(hWnd, 0)
int			ProgressBar_GetRangeMax(HWND hWnd)
{
	return ProgressBar_GetRange( hWnd, 0 );
}
/// ProgressBar_GetRange Q
/// ProgressBar_GetRange(hWnd, 1)
int			ProgressBar_GetRangeMin(HWND hWnd)
{
	return ProgressBar_GetRange( hWnd, 1 );
}
/**********************************************************************//**
 *
 * o[̐Fݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= F
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	ProgressBar_SetBarColor(HWND hWnd, COLORREF color)
{
#if	!defined(IRIS_WIN32_WCE)
	return (COLORREF)SendMessage( hWnd, PBM_SETBARCOLOR, 0, (LPARAM)color );
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	return color;
#endif
}
/**********************************************************************//**
 *
 * wiF̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= F
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	ProgressBar_SetBkColor(HWND hWnd, COLORREF color)
{
	return ComControl_SetBkColor(hWnd, color);
}
/**********************************************************************//**
 *
 * ʒuݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nPos	= ʒu
 * @return	ȑÖʒu
*//***********************************************************************/
int			ProgressBar_SetPos(HWND hWnd, int nPos)
{
	return (int)SendMessage( hWnd, PBM_SETPOS, (WPARAM)nPos, 0 );
}
/**********************************************************************//**
 *
 * ͈͂̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	wLower	= ͈͂̉
 * @param [in]	wUpper	= ͈͂̏
 * @return	ȑO͈̔
*//***********************************************************************/
LRESULT		ProgressBar_SetRange(HWND hWnd, WORD wLower, WORD wUpper)
{
	return SendMessage( hWnd, PBM_SETRANGE, 0, MAKELPARAM(wLower, wUpper) );
}
/**********************************************************************//**
 *
 * ͈͂̐ݒ(32bit)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nLower	= ͈͂̉
 * @param [in]	nUpper	= ͈͂̏
 * @return	ȑO͈̔
*//***********************************************************************/
LRESULT		ProgressBar_SetRange32(HWND hWnd, int nLower, int nUpper)
{
#if (_WIN32_IE >= 0x0300)
	return SendMessage( hWnd, PBM_SETRANGE32, (WPARAM)nLower, (LPARAM)nUpper );
#else
	return SendMessage( hWnd, PBM_SETRANGE, 0, MAKELPARAM(uLower, uUpper) );
#endif
}
/**********************************************************************//**
 *
 * l̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nStep	= l
 * @return	ȑȎl
*//***********************************************************************/
int			ProgressBar_SetStep(HWND hWnd, int nStep)
{
	return (int)SendMessage( hWnd, PBM_SETSTEP, (WPARAM)nStep, 0 );
}
/**********************************************************************//**
 *
 * ʒu𑝕li߂
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ȑȎl
*//***********************************************************************/
int			ProgressBar_StepIt(HWND hWnd)
{
	return (int)SendMessage( hWnd, PBM_STEPIT, 0, 0 );
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CProgressBar::CProgressBar(void)
{
	CComCtrl::Initialize(ICC_PROGRESS_CLASS);
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CProgressBar::CProgressBar(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_PROGRESS_CLASS);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CProgressBar::~CProgressBar(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CProgressBar::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(PROGRESS_CLASS
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CProgressBar::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(PROGRESS_CLASS
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CProgressBar::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, PROGRESS_CLASS
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CProgressBar::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, PROGRESS_CLASS
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CProgressBar::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
LRESULT		CProgressBar::DeltaPos(int nDelta)							{ return ProgressBar_DeltaPos(m_hWnd, nDelta); }
int			CProgressBar::GetPos(void)							const	{ return ProgressBar_GetPos(m_hWnd); }
int			CProgressBar::GetRange(BOOL bLow)					const	{ return ProgressBar_GetRange(m_hWnd, bLow); }
void		CProgressBar::GetRange(int& nLower, int& nUpper)	const	{ ProgressBar_GetRange(m_hWnd, nLower, nUpper); }
int			CProgressBar::GetRangeMax(void)						const	{ return ProgressBar_GetRangeMax(m_hWnd); }
int			CProgressBar::GetRangeMin(void)						const	{ return ProgressBar_GetRangeMin(m_hWnd); }
COLORREF	CProgressBar::SetBarColor(COLORREF color)					{ return ProgressBar_SetBarColor(m_hWnd, color); }
COLORREF	CProgressBar::SetBkColor(COLORREF color)					{ return ProgressBar_SetBkColor(m_hWnd, color); }
int			CProgressBar::SetPos(int nPos)								{ return ProgressBar_SetPos(m_hWnd, nPos); }
LRESULT		CProgressBar::SetRange(WORD wLower, WORD wUpper)			{ return ProgressBar_SetRange(m_hWnd, wLower, wUpper); }
LRESULT		CProgressBar::SetRange32(int nLower, int nUpper)			{ return ProgressBar_SetRange32(m_hWnd, nLower, nUpper); }
int			CProgressBar::SetStep(int nStep)							{ return ProgressBar_SetStep(m_hWnd, nStep); }
LRESULT		CProgressBar::StepIt(void)									{ return ProgressBar_StepIt(m_hWnd); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
