//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPropertySheetPage.cpp
 * @brief		vpeBV[gy[WNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPropertySheetPage_CPP_

//======================================================================
// include
#include "WXPropertySheetPage.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CPropertySheetPage
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPropertySheetPage::CPropertySheetPage(void)
: m_hPsp(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPropertySheetPage::~CPropertySheetPage(void)
{
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hPsp	= vpeBV[gy[Wnh
 * return	
*//***********************************************************************/
bool CPropertySheetPage::Attach(HPROPSHEETPAGE hPsp)
{
	if( m_hPsp != nullptr ) return false;
	m_hPsp = hPsp;
	return true;
}

/**********************************************************************//**
 *
 * ֘At̉
 *
 ----------------------------------------------------------------------
 * return	ȑÕvpeBV[gy[Wnh
*//***********************************************************************/
HPROPSHEETPAGE CPropertySheetPage::Detach(void)
{
	HPROPSHEETPAGE hPre = m_hPsp;
	m_hPsp = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpPsp	= vpeBV[gݒ\
 * return	
*//***********************************************************************/
bool CPropertySheetPage::Create (LPPROPSHEETPAGE  lpPsp)
{
#ifdef UNICODE
	return CreateW(lpPsp);
#else
	return CreateA(lpPsp);
#endif
}
/// CPropertySheetPage::Create Q
bool CPropertySheetPage::CreateA(LPPROPSHEETPAGEA lpPsp)
{
	HPROPSHEETPAGE hPsp = CreatePropertySheetPageA(lpPsp);
	if( Attach(hPsp) )
	{
		DestroyPropertySheetPage(hPsp);
		return false;
	}
	return true;
}
bool CPropertySheetPage::CreateW(LPPROPSHEETPAGEW lpPsp)
{
	HPROPSHEETPAGE hPsp = CreatePropertySheetPageW(lpPsp);
	if( Attach(hPsp) )
	{
		DestroyPropertySheetPage(hPsp);
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	hInstance	= CX^Xnh
 * @param [in]	dwFlags		= tO(PSP_***)
 * @param [in]	lpTempate	= _CAO\[X
 * @param [in]	pfnDlgProc	= _CAOvV[W
 * return	
*//***********************************************************************/
bool CPropertySheetPage::Create (HINSTANCE hInstance, DWORD dwFlags
								, LPCTSTR lpTempate, DLGPROC pfnDlgProc, LPCTSTR lpTitle
								, LPFNPSPCALLBACK  pfnCallback, LPARAM lParam)
{
#ifdef UNICODE
	return CreateW(hInstance, dwFlags, lpTempate, pfnDlgProc, lpTitle, pfnCallback, lParam);
#else
	return CreateA(hInstance, dwFlags, lpTempate, pfnDlgProc, lpTitle, pfnCallback, lParam);
#endif
}
/// CPropertySheetPage::Create Q
bool CPropertySheetPage::CreateA(HINSTANCE hInstance, DWORD dwFlags
								, LPCSTR  lpTempate, DLGPROC pfnDlgProc, LPCSTR  lpTitle
								, LPFNPSPCALLBACKA pfnCallback, LPARAM lParam)
{
	PROPSHEETPAGEA psp = {0};
	psp.dwSize		= sizeof(PROPSHEETPAGEA);
	psp.dwFlags		= dwFlags;
	psp.hInstance	= hInstance;
	psp.pszTemplate	= lpTempate;
	psp.pfnDlgProc	= pfnDlgProc;
	psp.pszTitle	= lpTitle;
	psp.pfnCallback	= pfnCallback;
	psp.lParam		= lParam;
	HPROPSHEETPAGE hPsp = CreatePropertySheetPageA(&psp);
	if( Attach(hPsp) )
	{
		DestroyPropertySheetPage(hPsp);
		return false;
	}
	return true;
}
/// CPropertySheetPage::Create Q
bool CPropertySheetPage::CreateW(HINSTANCE hInstance, DWORD dwFlags
								, LPCWSTR lpTempate, DLGPROC pfnDlgProc, LPCWSTR lpTitle
								, LPFNPSPCALLBACKW pfnCallback, LPARAM lParam)
{
	PROPSHEETPAGEW psp = {0};
	psp.dwSize		= sizeof(PROPSHEETPAGEW);
	psp.dwFlags		= dwFlags;
	psp.hInstance	= hInstance;
	psp.pszTemplate	= lpTempate;
	psp.pfnDlgProc	= pfnDlgProc;
	psp.pszTitle	= lpTitle;
	psp.pfnCallback	= pfnCallback;
	psp.lParam		= lParam;
	HPROPSHEETPAGE hPsp = CreatePropertySheetPageW(&psp);
	if( Attach(hPsp) )
	{
		DestroyPropertySheetPage(hPsp);
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPropertySheetPage::Release(void)
{
	DestroyPropertySheetPage(Detach());
}

}	// end of namespace wx
}	// end of namespace iris
