//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMenu.h
 * @brief		Menu t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMenu_H_
#define INCG_IRIS_WXMenu_H_

//======================================================================
// icnlude
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CMenu;

//======================================================================
// function

// 擾
// hMenuȉׂ̂Ă
UINT	GetMenuStringFromID		(HMENU hMenu, UINT uID , LPTSTR lpString, UINT uSize);
UINT	GetMenuStringFromIDA	(HMENU hMenu, UINT uID , LPSTR  lpString, UINT uSize);
UINT	GetMenuStringFromIDW	(HMENU hMenu, UINT uID , LPWSTR lpString, UINT uSize);
UINT	GetMenuStringFromPos	(HMENU hMenu, UINT uPos, LPTSTR lpString, UINT uSize);
UINT	GetMenuStringFromPosA	(HMENU hMenu, UINT uPos, LPSTR  lpString, UINT uSize);
UINT	GetMenuStringFromPosW	(HMENU hMenu, UINT uPos, LPWSTR lpString, UINT uSize);

// 
HMENU	FindRootMenu(HMENU hMenu, UINT uID);
HMENU	FindMenu(HMENU hMenu, UINT uID);
HMENU	FindMenuItemInfo (HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFO  lpmii);
HMENU	FindMenuItemInfoA(HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFOA lpmii);
HMENU	FindMenuItemInfoW(HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFOW lpmii);

// j[ʒu̎擾
int		GetMenuItemPos(HMENU hMenu, UINT uID);

// |bvAbvj[̕\i}EXJ[\t߂ɏoj
BOOL	ShowPopupMenu(HWND hWnd, HMENU hMenu, LPRECT prc);

//======================================================================
// class
//! j[NX
class CMenu : public IIrisObject
{
protected:
	HMENU	m_hMenu;	//!< j[nh

public:
	// RXgN^
	CMenu(void);
	CMenu(HMENU hMenu);
	CMenu(HWND hWnd);
	// fXgN^
	~CMenu(void);
public:
    // j[nh̎擾
	HMENU	GetMenu(void)		const	{ return m_hMenu; }
	HMENU	operator()(void)	const	{ return m_hMenu; }
	operator HMENU (void)		const	{ return m_hMenu; }

public:
    // j[֘At
    bool	Attach(HMENU hMenu);
    // j[̊֘At𕪗
    HMENU	Detach(void);

public:
    // j[쐬
    BOOL	CreateMenu(void);
    // |bvAbvj[쐬
    BOOL	CreatePopupMenu(void);
	// j[̃[h
	BOOL	LoadMenuA(HINSTANCE hInstance, LPCSTR  lpMenuName);
	BOOL	LoadMenuW(HINSTANCE hInstance, LPCWSTR lpMenuName);
	// j[̔j
    BOOL	DestroyMenu(void);

public:
	// j[ǉ
	BOOL	InsertMenuItemA(UINT uItem, BOOL fByPos, LPCMENUITEMINFOA lpmii);
	BOOL	InsertMenuItemW(UINT uItem, BOOL fByPos, LPCMENUITEMINFOW lpmii);
	// j[폜
	BOOL	DeleteMenu(UINT uItem, UINT uFlags);
	// j[폜iȂj
	HMENU	RemoveMenu(UINT uItem, UINT uFlags);

public:
	// j[I
	BOOL	SelectMenuItem(HWND hWnd, int nPos);
	// j[
	BOOL	PushMenuItem(HWND hWnd, int nPos);

public:
	// j[Ƀ`FbN
	BOOL	CheckMenuItem(UINT uItem, UINT uCheck);
	// j[ɃWI{^`FbN
	BOOL	CheckMenuRadioItem(UINT uFirst, UINT uLast, UINT uCheck, UINT uFlags);
	BOOL	CheckMenuRadioItem(UINT uCheck, UINT uFlags);
	// j[ڂLAA܂͒WF\ɂ
	BOOL	EnableMenuItem(UINT uID, UINT uEnable);
	// j[擾
	BOOL	GetMenuInfo(LPMENUINFO lpmi) const;
	// j[ڐ̎擾
	int		GetMenuItemCount(void) const;
	// j[ID̎擾
	UINT	GetMenuItemID(int nPos) const;
	// j[ACe\̂fMasko擾
	DWORD	GetMenuItemInfoMask(UINT uItem, BOOL fByPosition) const;
	// j[ACe\̂fTypeo擾
	DWORD	GetMenuItemInfoType(UINT uItem, BOOL fByPosition) const;
	// j[ACe\̂fStateo擾
	DWORD	GetMenuItemInfoState(UINT uItem, BOOL fByPosition) const;
	// j[ACȅ擾
	BOOL	GetMenuItemInfoA(UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii) const;
	BOOL	GetMenuItemInfoW(UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii) const;
	// j[ACë̗擾
	BOOL	GetMenuItemRect(HWND hWnd, UINT uItem, LPRECT lprc) const;
	// Tuj[̎擾
	HMENU	GetSubMenu(int nPos) const;
	// nCCgݒ
	BOOL	HiliteMenuItem(HWND hWnd, UINT uID, UINT uHilite);
	// j[nhǂ
	BOOL	IsMenu(void) const;
	// |bvAbvj[ǂ
	BOOL	IsPopupMenu(void) const;
	// ʒu烁j[nh擾
	int		MenuItemFromPoint(HWND hWnd, POINT ptScreen) const;
	// j[ݒ
	BOOL	SetMenuInfo(LPCMENUINFO lpmi);
	// rbg}bvj[Ɋ֘At
	BOOL	SetMenuItemBitmaps(UINT uItem, UINT uFlags, HBITMAP hBitmapUnchecked, HBITMAP hBitmapChecked);
	// j[ACeݒ
	BOOL	SetMenuItemInfoA(UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
	BOOL	SetMenuItemInfoW(UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
	// V[gJbgj[̕\
	BOOL	TrackPopup(UINT uFlags, int x, int y, HWND hWnd);
	BOOL	TrackPopupEx(UINT uFlags, int x, int y, HWND hWnd, LPTPMPARAMS lptpm);

public:
	// hMenuȉׂ̂Ă
	UINT	GetMenuStringFromID	(UINT uID, LPTSTR lpString, UINT uSize) const;
	UINT	GetMenuStringFromIDA(UINT uID, LPSTR  lpString, UINT uSize) const;
	UINT	GetMenuStringFromIDW(UINT uID, LPWSTR lpString, UINT uSize) const;
	UINT	GetMenuStringFromPos (UINT uPos, LPTSTR lpString, UINT uSize) const;
	UINT	GetMenuStringFromPosA(UINT uPos, LPSTR  lpString, UINT uSize) const;
	UINT	GetMenuStringFromPosW(UINT uPos, LPWSTR lpString, UINT uSize) const;

	// j[ACeIDAj[nh
	HMENU	FindRootMenu(UINT uID) const;
	HMENU	FindMenu(UINT uID) const;
	// j[ACě
	HMENU	FindMenuItemInfo (UINT uItem, BOOL fByPos, LPMENUITEMINFO  lpmii) const;
	HMENU	FindMenuItemInfoA(UINT uItem, BOOL fByPos, LPMENUITEMINFOA lpmii) const;
	HMENU	FindMenuItemInfoW(UINT uItem, BOOL fByPos, LPMENUITEMINFOW lpmii) const;

	// j[ʒu̎擾
	int		GetMenuItemPos(UINT uID) const;

	// |bvAbvj[̕\i}EXJ[\t߂ɏoj
	BOOL	ShowPopupMenu(HWND hWnd, RECT* prc);

public:
	// j[
	static LRESULT	PushMenu (HWND hWnd, HMENU hRootMenu, LPMENUITEMINFO  lpmii);
	static LRESULT	PushMenuA(HWND hWnd, HMENU hRootMenu, LPMENUITEMINFOA lpmii);
	static LRESULT	PushMenuW(HWND hWnd, HMENU hRootMenu, LPMENUITEMINFOW lpmii);

public:
	// 񂩂I
	template<typename _FUNC>
	static LRESULT	PushMenu (HWND hWnd, HMENU hMenu, const _FUNC& func, LPCTSTR rhs)
	{
		MENUITEMINFO mii = {0};
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_STATE|MIIM_ID;
		HMENU hSubMenu = FindMenuItemInfo(hMenu, &mii, func, rhs);
		return PushMenu(hWnd, hSubMenu, &mii);
	}
	template<typename _FUNC>
	static LRESULT	PushMenuA(HWND hWnd, HMENU hMenu, const _FUNC& func, LPCSTR rhs)
	{
		MENUITEMINFOA mii = {0};
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_STATE|MIIM_ID;
		HMENU hSubMenu = FindMenuItemInfoA(hMenu, &mii, func, rhs);
		return PushMenuA(hWnd, hSubMenu, &mii);
	}
	template<typename _FUNC>
	static LRESULT	PushMenuW(HWND hWnd, HMENU hMenu, const _FUNC& func, LPCWSTR rhs)
	{
		MENUITEMINFOW mii = {0};
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_STATE|MIIM_ID|MIIM_SUBMENU;
		HMENU hSubMenu = FindMenuItemInfoW(hMenu, &mii, func, rhs);
		return PushMenuW(hWnd, hSubMenu, &mii);
	}

public:
	// LvV猟
	template<typename _FUNC>
	static HMENU		FindMenuItemInfo(HMENU hMenu, LPMENUITEMINFO  lpmii, const _FUNC& func, LPCTSTR rhs)
	{
#ifdef UNICODE
		return FindMenuItemInfoW(hMenu, lpmii, func, rhs);
#else
		return FindMenuItemInfoA(hMenu, lpmii, func, rhs);
#endif
	}
	template<typename _FUNC>
	static HMENU		FindMenuItemInfoA(HMENU hMenu, LPMENUITEMINFOA lpmii, const _FUNC& func, LPCSTR rhs)
	{
		CHAR text[256];
		MENUITEMINFOA mii = {0};
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_STRING;
		mii.dwTypeData = text;
		mii.cch = 256;
		return FindMenuItemInfoA(hMenu, lpmii, func, rhs, &mii);
	}
	template<typename _FUNC>
	static HMENU		FindMenuItemInfoW(HMENU hMenu, LPMENUITEMINFOW lpmii, const _FUNC& func, LPCWSTR rhs)
	{
		WCHAR text[256];
		MENUITEMINFOW mii = {0};
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_STRING;
		mii.dwTypeData = text;
		mii.cch = 256;
		return FindMenuItemInfoW(hMenu, lpmii, func, rhs, &mii);
	}


private:
	// LvV猟
	template<typename _FUNC>
	static HMENU		FindMenuItemInfoA(HMENU hMenu, LPMENUITEMINFOA lpmii, const _FUNC& func, LPCSTR rhs, LPMENUITEMINFOA lpwork)
	{
		UINT cch = lpwork->cch;
		int cnt=::GetMenuItemCount(hMenu);
		for( int i=0; i < cnt; ++i )
		{
			if( ::GetMenuItemInfoA(hMenu, i, MF_BYPOSITION, lpwork) )
			{
				if( lpwork->dwTypeData != nullptr )
				{
					if( func(lpwork->dwTypeData, rhs) )
					{
						::GetMenuItemInfoW(hMenu, i, MF_BYPOSITION, lpmii);
						return hMenu;
					}
				}
			}
			lpwork->cch = cch;
		}

		HMENU hSubMenu = ::GetSubMenu(hMenu, 0);
		for( int i=0; i < cnt; ++i, hSubMenu = ::GetSubMenu(hMenu, i) )
		{
			if( FindMenuItemInfoA(hSubMenu, lpmii, func, rhs, lpwork) != nullptr ) return hSubMenu;
		}
		return nullptr;
	}
	template<typename _FUNC>
	static HMENU		FindMenuItemInfoW(HMENU hMenu, LPMENUITEMINFOW lpmii, const _FUNC& func, LPCWSTR rhs, LPMENUITEMINFOW lpwork)
	{
		UINT cch = lpwork->cch;
		int cnt=::GetMenuItemCount(hMenu);
		for( int i=0; i < cnt; ++i )
		{
			if( ::GetMenuItemInfoW(hMenu, i, MF_BYPOSITION, lpwork) )
			{
				if( lpwork->dwTypeData != nullptr )
				{
					if( func(lpwork->dwTypeData, rhs) )
					{
						::GetMenuItemInfoW(hMenu, i, MF_BYPOSITION, lpmii);
						return hMenu;
					}
				}
			}
			lpwork->cch = cch;
		}

		HMENU hSubMenu = ::GetSubMenu(hMenu, 0);
		for( int i=0; i < cnt; ++i, hSubMenu = ::GetSubMenu(hMenu, i) )
		{
			if( FindMenuItemInfoW(hSubMenu, lpmii, func, rhs, lpwork) != nullptr ) return hSubMenu;
		}
		return nullptr;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
