//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTaskbarList.h
 * @brief		WXTaskbarList t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXTaskbarList_H_
#define INCG_IRIS_WXTaskbarList_H_

//======================================================================
// include
#include "WXComObj.h"
#include "../shell/shlobj_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ITaskbarList NX
*/
class CTaskbar : public IIrisObject
{
protected:
#ifdef __ITaskbarList3_FWD_DEFINED__
	CComObj<ITaskbarList3>	m_pTaskbarList3;
#endif
#ifdef __ITaskbarList2_FWD_DEFINED__
	CComObj<ITaskbarList2>	m_pTaskbarList2;
#endif
	CComObj<ITaskbarList>	m_pTaskbarList;

public:
	// RXgN^
	CTaskbar(void);
	// fXgN^
	~CTaskbar(void);

public:
	// ITaskbarList
	// 
	HRESULT	Initialize(void);

	// ^uǉ
	HRESULT	AddTab(HWND hWnd);
	// ^u폜
	HRESULT	DeleteTab(HWND hWnd);
	// ^ũANeBx[g
	HRESULT	ActivateTab(HWND hWnd);
	//
	HRESULT	SetActiveAlt(HWND hWnd);

public:
	// ITaskbarList2
	// tXN[EBhEǂʒm
	HRESULT	MarkFullscreenWindow(HWND hWnd, BOOL bFullscreen);

public:
	// vOX\̒lݒ
	HRESULT	SetProgressValue(HWND hWnd, ULONGLONG ullCompleted, ULONGLONG ullTotal);
	// vOX\̏Ԑݒ
	HRESULT	SetProgressState(HWND hWnd, TBPFLAG tbFlag);
	/// vOX\OFF
	HRESULT	SetProgressHide(HWND hWnd)				{ return SetProgressState(hWnd, TBPF_NOPROGRESS); }
	/// vOX\sԂɕύX
	HRESULT	SetProgressIndeterminate(HWND hWnd)		{ return SetProgressState(hWnd, TBPF_INDETERMINATE); }
	/// vOX\ʏԂɕύX
	HRESULT	SetProgressNormal(HWND hWnd)			{ return SetProgressState(hWnd, TBPF_NORMAL); }
	/// vOX\x~ԂɕύX
	HRESULT	SetProgressPaused(HWND hWnd)			{ return SetProgressState(hWnd, TBPF_PAUSED); }
	/// vOX\sԂɕύX
	HRESULT	SetProgressError(HWND hWnd)				{ return SetProgressState(hWnd, TBPF_ERROR); }

	//
	HRESULT	RegisterTab(HWND hWnd, HWND hWndMDI);
	//
	HRESULT	UnregisterTab(HWND hWnd);
	//
	HRESULT	SetTabActive(HWND hWnd, HWND hWndMDI, DWORD dwReserved=0);
	// ^uI[_[ύX
	HRESULT	SetTabOrder(HWND hWnd, HWND hInsertBefore);

	// TlC\Ƀ{^ǉ
	HRESULT	ThumbBarAddButtons(HWND hWnd, UINT nButtons, LPTHUMBBUTTON pButton);
	// TlC\{^XV
	HRESULT	ThumbBarUpdateButtons(HWND hWnd, UINT nButtons, LPTHUMBBUTTON pButton);
	// TlC\ɃC[WXgݒ
	HRESULT	ThumbBarSetImageList(HWND hWnd, HIMAGELIST hIml);
	// I[oCACR̐ݒ
	HRESULT	SetOverlayIcon(HWND hWnd, HICON hIcon, LPCWSTR pszDescription);
	// TlC̃c[`bvݒ
	HRESULT	SetThumbnailTooltip(HWND hWnd, LPCWSTR pszTip);
	// TlC̃Nbv̈ݒ
	HRESULT	SetThumbnailClip(HWND hWnd, LPRECT lprcClip);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
