//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTaskbarList.cpp
 * @brief		WXTaskbarList t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXTaskbarList_CPP_

//======================================================================
// include
#include "WXTaskbarList.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CTaskbar::CTaskbar(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CTaskbar::~CTaskbar(void)
{
#ifdef __ITaskbarList3_FWD_DEFINED__
	m_pTaskbarList3.Delete();
#endif
#ifdef __ITaskbarList2_FWD_DEFINED__
	m_pTaskbarList2.Delete();
#endif
	m_pTaskbarList.Delete();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::Initialize(void)
{
#ifdef __ITaskbarList3_FWD_DEFINED__
	if( SUCCEEDED( m_pTaskbarList3.Create(CLSID_TaskbarList, nullptr, CLSCTX_INPROC
		, IID_ITaskbarList3) ) )
	{
#ifdef __ITaskbarList2_FWD_DEFINED__
		m_pTaskbarList2 = m_pTaskbarList3;
#endif
		m_pTaskbarList = m_pTaskbarList3;
	}
#endif
#ifdef __ITaskbarList2_FWD_DEFINED__
	if( !m_pTaskbarList2.IsValid() )
	{
		if( SUCCEEDED( m_pTaskbarList2.Create(CLSID_TaskbarList, nullptr, CLSCTX_INPROC
			, IID_ITaskbarList2) ) )
		{
			m_pTaskbarList = m_pTaskbarList2;
		}
	}
#endif
	if( !m_pTaskbarList.IsValid() )
	{
		if( FAILED( m_pTaskbarList.Create(CLSID_TaskbarList, nullptr, CLSCTX_INPROC
			, IID_ITaskbarList) ) )
		{
			return E_NOINTERFACE;
		}
	}
	return m_pTaskbarList->HrInit();
}

/**********************************************************************//**
 *
 * ^uǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ǉEBhẼnh
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::AddTab(HWND hWnd)
{
	IRIS_ASSERT( m_pTaskbarList.IsValid() );
	return m_pTaskbarList->AddTab(hWnd);
}

/**********************************************************************//**
 *
 * ^u폜
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= 폜EBhẼnh
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::DeleteTab(HWND hWnd)
{
	IRIS_ASSERT( m_pTaskbarList.IsValid() );
	return m_pTaskbarList->DeleteTab(hWnd);
}

/**********************************************************************//**
 *
 * ^ũANeBx[g
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ANeBx[gEBhẼnh
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::ActivateTab(HWND hWnd)
{
	IRIS_ASSERT( m_pTaskbarList.IsValid() );
	return m_pTaskbarList->ActivateTab(hWnd);
}

/**********************************************************************//**
 *
 * ^ũ}[N
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= }[NEBhẼnh
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetActiveAlt(HWND hWnd)
{
	IRIS_ASSERT( m_pTaskbarList.IsValid() );
	return m_pTaskbarList->SetActiveAlt(hWnd);
}

/**********************************************************************//**
 *
 * tXN[EBhEǂʒm
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	bFullscreen	= tXN[ǂ
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::MarkFullscreenWindow(HWND hWnd, BOOL bFullscreen)
{
#ifdef __ITaskbarList2_FWD_DEFINED__
	if( !m_pTaskbarList2.IsValid() ) return E_POINTER;
	return m_pTaskbarList2->MarkFullscreenWindow(hWnd, bFullscreen);
#elif	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->MarkFullscreenWindow(hWnd, bFullscreen);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * vOX\̏Ԑݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= EBhEnh
 * @param [in]	ullCompleted	= il
 * @param [in]	ullTotal		= l
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetProgressValue(HWND hWnd, ULONGLONG ullCompleted, ULONGLONG ullTotal)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetProgressValue(hWnd, ullCompleted, ullTotal);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * vOX\̏Ԑݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	tbFlag	= ԃtOiTBPF_***j
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetProgressState(HWND hWnd, TBPFLAG tbFlag)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetProgressState(hWnd, tbFlag);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	hWndMDI		= 
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::RegisterTab(HWND hWnd, HWND hWndMDI)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->RegisterTab(hWnd, hWndMDI);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::UnregisterTab(HWND hWnd)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->UnregisterTab(hWnd);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	hWndMDI		= 
 * @param [in]	dwReserved	= \
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetTabActive(HWND hWnd, HWND hWndMDI, DWORD dwReserved)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetTabActive(hWnd, hWndMDI, dwReserved);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * ^uI[_[ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= EBhEnh
 * @param [in]	hInsertBefore	= w肵EBhȆOɃI[_[ύX
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetTabOrder(HWND hWnd, HWND hInsertBefore)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetTabOrder(hWnd, hInsertBefore);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * TlC\Ƀ{^ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	nButtons	= {^
 * @param [in]	pButton		= {^
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::ThumbBarAddButtons(HWND hWnd, UINT nButtons, LPTHUMBBUTTON pButton)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->ThumbBarAddButtons(hWnd, nButtons, pButton);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * TlC\{^XV
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	nButtons	= {^
 * @param [in]	pButton		= {^
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::ThumbBarUpdateButtons(HWND hWnd, UINT nButtons, LPTHUMBBUTTON pButton)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->ThumbBarUpdateButtons(hWnd, nButtons, pButton);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * TlC\ɃC[WXgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	hIml		= C[WXg
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::ThumbBarSetImageList(HWND hWnd, HIMAGELIST hIml)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->ThumbBarSetImageList(hWnd, hIml);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * I[oCACR̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	nButtons	= ACR
 * @param [in]	pButton		= 
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetOverlayIcon(HWND hWnd, HICON hIcon, LPCWSTR pszDescription)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetOverlayIcon(hWnd, hIcon, pszDescription);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * TlC̃c[`bvݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	pszTip		= c[`bveLXg
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetThumbnailTooltip(HWND hWnd, LPCWSTR pszTip)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetThumbnailTooltip(hWnd, pszTip);
#else
	return E_NOINTERFACE;
#endif
}

/**********************************************************************//**
 *
 * TlC̃Nbv̈ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	lprcClip	= Nbv̈
 * @return	
*//***********************************************************************/
HRESULT CTaskbar::SetThumbnailClip(HWND hWnd, LPRECT lprcClip)
{
#if	defined(__ITaskbarList3_FWD_DEFINED__)
	if( !m_pTaskbarList3.IsValid() ) return E_POINTER;
	return m_pTaskbarList3->SetThumbnailClip(hWnd, lprcClip);
#else
	return E_NOINTERFACE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "../gdi/WXPaintStruct.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>

//======================================================================
// class
class CWXTaskbarListUnitTest : public iris::wx::dbg::CUnitTest<CWXTaskbarListUnitTest>
{
public:
	HWND	m_hWnd;
	CTaskbar taskbar;

protected:
	virtual bool	SetUp(void)
	{
		if( FAILED(taskbar.Initialize()) ) return false;
		return true;
	}

public:
	virtual void OnPaint(HWND hWnd)
	{
	}

protected:
	void begin(void)
	{
		HWND hWnd = nullptr;

		// EBhE̍쐬
		hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX
			, GetTestName()
			, GetTestName()
			, WINDOW_STYLE
			, 0
			, 0
			, DrawTestWindowProc
			);

		// EBhE̍쐬Ɏs
		if( hWnd == nullptr ) return;

		// EBhE\
		ShowWindow(hWnd, SW_SHOW);
		// EBhE̍XV
		UpdateWindow(hWnd);
		// őOʂ
		SetForegroundWindow(hWnd);

		m_hWnd = hWnd;
	}
	void end(void)
	{
		// bZ[W[v
		wx::dbg::UnitTestMainLoop(m_hWnd);
	}
};

//======================================================================
// test
IRIS_UNITTEST_F(CWXTaskbarListUnitTest, AddTab)
{
	begin();

	taskbar.DeleteTab(m_hWnd);

	Pause();

	taskbar.AddTab(m_hWnd);

	taskbar.ActivateTab(m_hWnd);

	end();
}

IRIS_UNITTEST_F(CWXTaskbarListUnitTest, Progress)
{
	begin();

	taskbar.SetProgressNormal(m_hWnd);
	taskbar.SetProgressValue(m_hWnd, 0, 100);

	for( int i=0; i < 50; ++i )
	{
		taskbar.SetProgressValue(m_hWnd, i, 100);
		Sleep(100);
	}

	taskbar.SetProgressPaused(m_hWnd);
	Pause();

	taskbar.SetProgressIndeterminate(m_hWnd);
	for( int i=50; i < 80; ++i )
	{
		taskbar.SetProgressValue(m_hWnd, i, 100);
		Sleep(100);
	}

	taskbar.SetProgressError(m_hWnd);

	Pause();

	taskbar.SetProgressHide(m_hWnd);

	taskbar.ActivateTab(m_hWnd);

	end();
}

IRIS_UNITTEST_F(CWXTaskbarListUnitTest, Tooltip)
{
	begin();

	taskbar.SetThumbnailTooltip(m_hWnd, L"TlCc[`bveXg");

	end();
}


#endif
