//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXInuptDevice.cpp
 * @brief		directX ̓foCXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXInuptDevice_CPP_

//======================================================================
// include
#include "DXInputDevice.h"
#include "../DXError.h"

#include "../../win/debug/WXDebug.h"

namespace iris {
namespace dx
{

//======================================================================
// link
#pragma comment (lib, "dinput8.lib")

//======================================================================
// define
// L[foCX̉
#define DXINPUT_SAFE_RELEASE( p )	{ if(p) { p->Unacquire(); p->Release(); p = nullptr; } }

//======================================================================
// class

//======================================================================
// IDXInputDevice
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXInputDevice::IDXInputDevice(void)
: m_pDevice(nullptr)
, m_fRepeatLoop(DX_KEY_REPEATLOOP)
, m_fRepeatFirst(DX_KEY_REPEATFIRST)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXInputDevice::~IDXInputDevice(void)
{
	Release();
}

/**********************************************************************//**
 *
 * WCpbh͈̎͐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	obj		= DIJOFS_***
 * @param [in]	range	= AiOXeBbN̕
 * @param [in]	margin	= AiOXeBbN̂
*//***********************************************************************/
void IDXInputDevice::SetJoypadAxis(DWORD obj, LONG range, LONG margin)
{
	if( m_pDevice == nullptr ) return;
	DIPROPRANGE diprg;
	ZeroMemory(&diprg , sizeof(diprg));
	diprg.diph.dwSize		= sizeof(diprg);
	diprg.diph.dwHeaderSize	= sizeof(diprg.diph);
	diprg.diph.dwHow		= DIPH_BYOFFSET;
	diprg.lMin				= -range;
	diprg.lMax				=  range;
	// ͈͂ݒ
	diprg.diph.dwObj		= obj;
	m_pDevice->SetProperty(DIPROP_RANGE , &diprg.diph);

	DIPROPDWORD dipdw;
	dipdw.diph.dwSize		= sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize	= sizeof(dipdw.diph);
	dipdw.diph.dwHow		= DIPH_BYOFFSET;
	dipdw.dwData			= margin;
	// ][ݒ
	dipdw.diph.dwObj		= obj;
	m_pDevice->SetProperty(DIPROP_DEADZONE , &dipdw.diph);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void IDXInputDevice::Release(void)
{
	for( CKeyMap::iterator it = m_Keys.begin(); it != m_Keys.end(); )
	{
		LPKeyState p = it->second;
		it = m_Keys.erase(it);
		delete p;
	}
	DXINPUT_SAFE_RELEASE( m_pDevice );
}

/**********************************************************************//**
 *
 * foCXԂύXꂽƂʒm
 *
*//***********************************************************************/
void IDXInputDevice::UpdateDevice(void)
{
	for( CKeyMap::iterator it = m_Keys.begin(), end = m_Keys.end(); it != end; ++it )
	{
		it->second->UpdateDevice(m_pDevice);
	}
}

/**********************************************************************//**
 *
 * L[NA
 *
 ----------------------------------------------------------------------
 * @param [in]	rMap	= L[Xg
*//***********************************************************************/
void IDXInputDevice::_Clear(CKeyMap& rMap)
{
	for( CKeyMap::iterator it = rMap.begin(), end = rMap.end(); it != end; ++it )
		it->second->Clear();
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	type	= foCX^Cv
 * @param [in]	id		= L[ID
 * @return	L[NX
*//***********************************************************************/
IDXInputDevice::LPKEYSTATE IDXInputDevice::GetKey(UINT uID) const
{
	CKeyMap::const_iterator it = m_Keys.find(uID);
	if( it == m_Keys.end() )	return nullptr;
	if( it->first != uID )		return nullptr;
	return it->second;
}

/**********************************************************************//**
 *
 * L[̓o^
 *
 ----------------------------------------------------------------------
 * @param [in]	rMap	= L[Xg
 * @param [in]	uID		= L[ID
 * @param [in]	lpKey	= L[NX
 * @return	
*//***********************************************************************/
bool IDXInputDevice::_RegisterKey(CKeyMap &rMap, UINT uID, LPKEYSTATE lpKey)
{
	if( lpKey == nullptr ) return false;
	rMap.insert( CKeyPair(uID, lpKey) );
	lpKey->UpdateDevice(m_pDevice);
	return true;
}

/**********************************************************************//**
 *
 * L[폜
 *
 *----------------------------------------------------------------------
 * @param [in]	rMap	= L[Xg
 * @param [in]	uID		= L[ID
 * @return	
*//***********************************************************************/
bool IDXInputDevice::_EraseKey(CKeyMap& rMap, UINT uID)
{
	CKeyMap::iterator it = rMap.find(uID);
	if( it == rMap.end() ) return false;
	if( it->first != uID ) return false;
	LPKEYSTATE p = it->second;
	rMap.erase(it);
	delete p;
	return true;
}

/**********************************************************************//**
 *
 * L[폜
 *
 *----------------------------------------------------------------------
 * @param [in]	rMap	= L[Xg
 * @param [in]	lpKey	= L[
 * @return	
*//***********************************************************************/
bool IDXInputDevice::_EraseKey(CKeyMap& rMap, LPKEYSTATE lpKey)
{
	if( lpKey == nullptr ) return false;
	for( CKeyMap::iterator it = rMap.begin(), end = rMap.end(); it != end; ++it )
	{
		if( it->second == lpKey )
		{
			rMap.erase(it);
			delete lpKey;
			return true;
		}
	}
	return false;
}

//======================================================================
// CDXJoyDevice
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXJoyDevice::CDXJoyDevice(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXJoyDevice::~CDXJoyDevice(void)
{
}

/**********************************************************************//**
 *
 * WCpbhXV
 *
*//***********************************************************************/
void CDXJoyDevice::Update(void)
{
	if( m_pDevice == nullptr ) return;

	m_pDevice->Poll();
	HRESULT hr = m_pDevice->Acquire();
	if( FAILED(hr) ) { return; }

	DIJOYSTATE2 joy_state;
	hr = m_pDevice->GetDeviceState(sizeof(joy_state), &joy_state);
	if( FAILED(hr) ) { DX_ERROR(hr); return; }

	for( CKeyMap::iterator it = m_Keys.begin(), end = m_Keys.end(); it != end; ++it )
	{
		LPDXJoyKeyState p = it->second;
		if( !p->JoyUpdate( &joy_state, m_fRepeatFirst, m_fRepeatLoop) )
		{
			p->Update( ((joy_state.rgbButtons[ p->GetKey() ] & 0x80) != 0), m_fRepeatFirst, m_fRepeatLoop);
		}
	}
}

//======================================================================
// CDXKeyDevice
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXKeyDevice::CDXKeyDevice(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXKeyDevice::~CDXKeyDevice(void)
{
}

/**********************************************************************//**
 *
 * L[{[hXV
 *
*//***********************************************************************/
void CDXKeyDevice::Update(void)
{
	if( m_pDevice == nullptr ) return;

	HRESULT hr = m_pDevice->Acquire();
	if( FAILED(hr) ) { return; }

	char key_state[256];
	hr = m_pDevice->GetDeviceState(sizeof(key_state), key_state);
	if( FAILED(hr) ) { DX_ERROR(hr); return; }

	for( CKeyMap::iterator it = m_Keys.begin(), end = m_Keys.end(); it != end; ++it )
	{
		LPDXJoyKeyState p = it->second;
		p->Update( ((key_state[ p->GetKey() ] & 0x80) != 0), m_fRepeatFirst, m_fRepeatLoop);
	}
}

}	// end of namespace dx
}	// end of namespace iris
