//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFog.h
 * @brief		tHONXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFog_H_
#define INCG_IRIS_DXFog_H_

//======================================================================
// include
#include "../layer/DXLayerObject.h"

namespace iris {
namespace dx
{

//======================================================================
// struct
//! tHOp[^\
typedef struct tagDXFOGPARAM
{
	intr::DXICOLOR	color;		//!< F
	f32				start;		//!< Jn
	f32				end;		//!< I
	f32				density;	//!< 
	bool			liner;		//!< 
	bool			pixel;		//!< 
	bool			range;		//!< 
	bool			enable;		//!< on / off
	tagDXFOGPARAM(bool _enable = false
		, intr::DXICOLOR _color = 0
		, f32 _start	= 1000.0f
		, f32 _end		= 1000000.0f
		, f32 _density	= 1.0f
		, bool _liner	= true
		, bool _pixel	= false
		, bool _range	= false
		)
		: enable(_enable), color(_color)
		, start(_start), end(_end)
		, density(_density)
		, liner(_liner), pixel(_pixel), range(_range)
	{}
} DXFOGPARAM, *LPDXFOGPARAM;	//!< tHOp[^\

//======================================================================
// class
/// tHONX
class CDXFog : public IDXLayerObject
{
protected:
	DXFOGPARAM	m_Param;
public:
	// RXgN^
	CDXFog(const DXFOGPARAM& rParam);
	CDXFog(bool enable = false
		, intr::DXICOLOR color = intr::DXICOLOR(0.0f, 0.0f, 0.0f, 0.0f)
		, f32 start		= 1000.0f
		, f32 end		= 1000000.0f
		, f32 density	= 1.0f
		, bool liner	= true
		, bool pixel	= false
		, bool range	= false
		);
public:
	/// 쐬
	virtual bool	Create(void) { return true; }
	/// XV
	virtual void	Update(f32 time) { IRIS_UNUSED_VARIABLE(time); }
	/// `
	virtual	void	Draw(void);
	// 
	virtual	void	Release(void);

protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);
protected:
	// K
	virtual bool	Activate(void);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
