//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXVertexBuffer.cpp
 * @brief		VertexBuffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXVertexBuffer_CPP_

//======================================================================
// include
#include "DXVertexBuffer.h"
#include "../DXDevice.h"
#include "../../DXError.h"
#include "../env/DXFVF.h"
#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXVertexBuffer::CDXVertexBuffer(void)
: m_lpVB(nullptr)
, m_dwFVF(0)
, m_uLength(0)
, m_uStride(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXVertexBuffer::~CDXVertexBuffer(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	uLength		= _obt@TCY
 * @param [in]	dwUsage		= gp@
 * @param [in]	dwFVF		= FVF
 * @param [in]	uStride		= FVF ̃XgCh
 * @param [in]	Pool		= POOL
 * @return	
*//***********************************************************************/
bool CDXVertexBuffer::Create(UINT uLength, DWORD dwUsage, DWORD dwFVF, UINT uStride, DXPOOL Pool)
{
	if( m_lpVB != nullptr ) return false;
	CDXDevice* pDevice = GetDXDevice();
	if( pDevice == nullptr ) return false;
	DX_DO_CHECK_RESULT(pDevice->GetDevice().CreateVertexBuffer(uLength, dwUsage, dwFVF, Pool,
											&m_lpVB)
					, return false);
	m_dwFVF = dwFVF;
	m_uLength = uLength;
	m_uStride = uStride;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXVertexBuffer::Release(void)
{
	DX_SAFE_RELEASE(m_lpVB);
}

/**********************************************************************//**
 *
 * Xg[ɐݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	StreamNumber	= Xg[ԍ
 * @param [in]	OffsetInBytes	= 擪̃ItZbg
 * @return	
*//***********************************************************************/
HRESULT CDXVertexBuffer::SetStreamSource(UINT StreamNumber, UINT OffsetInBytes)
{
	IRIS_VERIFYRETURN( m_lpVB != nullptr, E_POINTER );
	CDXDevice* pDevice = GetDXDevice();
	IRIS_VERIFYRETURN( pDevice != nullptr, E_POINTER );
#if !defined(_IRIS_SUPPORT_DXMOBILE)
	pDevice->GetDevice()->SetFVF(m_dwFVF);
#endif
	return pDevice->GetDevice().SetStreamSource(StreamNumber, m_lpVB, OffsetInBytes, m_uStride);
}

/**********************************************************************//**
 *
 * bN
 *
 ----------------------------------------------------------------------
 * @param [out]	ppbData	= o̓obt@
 * @param [in]	uOffset	= bNJnItZbg
 * @param [in]	uSize	= bNTCY(uOffset = 0 && uSize = 0 őS̃bN)
 * @param [in]	dwFlags	= bNtO
 * @return	
*//***********************************************************************/
HRESULT CDXVertexBuffer::Lock(void** ppbData, UINT uOffset, UINT uSize, DWORD dwFlags)
{
	IRIS_VERIFYRETURN( m_lpVB != nullptr, E_POINTER );
	return m_lpVB->Lock(uOffset, uSize, ppbData, dwFlags);
}

/**********************************************************************//**
 *
 * AbN
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT CDXVertexBuffer::Unlock(void)
{
	IRIS_VERIFYRETURN( m_lpVB != nullptr, E_POINTER );
	return m_lpVB->Unlock();
}

}	// end of namespace dx
}	// end of namespace iris
