//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMesh.cpp
 * @brief		directX bVNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMesh_CPP_

//======================================================================
// include
#include "DXMesh.h"
#include "../DXDevice.h"
#include "../../DXCoordinates.h"
#include "../../DXError.h"
#include "fnd/container/smart_ptr/FndAutoPtr.h"

namespace iris {
namespace dx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * eNX`֐
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice		= foCX
 * @param [in]	filename	= t@C
 * @param [out]	pTexture	= LPDIRECT3DTEXTURE9̃AhX
 * @return	HRESULTl
*//***********************************************************************/
HRESULT DXMeshDefaultCreateTexture( LPDXDEVICE pDevice
								   , LPCSTR filename
								   , LPDXTEXTURE* pTexture
								   )
{
	return D3DXCreateTextureFromFileExA(pDevice, filename
		, 0, 0, 0, 0
		, D3DFMT_UNKNOWN, D3DPOOL_MANAGED, D3DX_FILTER_NONE, D3DX_DEFAULT
		, 0x00000000, 0, 0, pTexture);
}

/**********************************************************************//**
 *
 * eNX`폜֐
 *
 ----------------------------------------------------------------------
 * @param [in]	pTexture	= eNX`
 * @return	HRESULTl
*//***********************************************************************/
HRESULT DXMeshDefaultDeleteTexture(LPDXTEXTURE* pTexture)
{
	if( pTexture == nullptr ) return S_FALSE;
	DX_SAFE_RELEASE( (*pTexture) );
	return S_OK;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXMesh::IDXMesh(void)
: CRenderState(DXRS_DEFAULT)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXMesh::~IDXMesh(void)
{
	Release();
}

/**********************************************************************//**
 *
 * JgfBNgw肵ēǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	pCurrentDirectory	= JgfBNg
 * @param [in]	pFileame			= t@C
 * @return	
*//***********************************************************************/
bool IDXMesh::LoadDirectory(LPCTSTR pCurrentDirectory, LPCTSTR pFileame)
{
	TCHAR cd[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, cd);
	SetCurrentDirectory(pCurrentDirectory);
	bool ret = Load(pFileame);
	SetCurrentDirectory(cd);
	return ret;
}

///**********************************************************************//**
// *
// * w肵|S̖@xNg擾
// *
// ----------------------------------------------------------------------
// * @param [out]	pVec	= @xNg
// * @param [in]	dwIndex	= CfbNX
// * @return	@xNg
//*//***********************************************************************/
//LPD3DXVECTOR3 IDXMesh::GetNormal(LPD3DXVECTOR3 pVec, DWORD dwIndex)
//{
//	LPDXMESH pMesh = GetMesh();
//	if( pMesh == nullptr ) return pVec;
//
//	LPDIRECT3DVERTEXBUFFER9	pVB = nullptr;	// _obt@
//	LPDIRECT3DINDEXBUFFER9	pIB = nullptr;	// CfbNXobt@
//	LPBYTE pVertices;
//	LPWORD pIndices;
//	DWORD dwfvfSize = D3DXGetFVFVertexSize(pMesh->GetFVF());
//
//	DX_DO_CHECK_RESULT( pMesh->GetVertexBuffer(&pVB), goto func_end );
//	DX_DO_CHECK_RESULT( pMesh->GetIndexBuffer(&pIB) , pVB->Release(); goto func_end );
//
//	// obt@bN
//	DX_DO_CHECK_RESULT( pVB->Lock(0, 0, (void**)&pVertices, D3DLOCK_READONLY)
//		, goto func_release_end);
//	DX_DO_CHECK_RESULT( pIB->Lock(3*sizeof(WORD)*dwIndex, 3*sizeof(WORD), (void**)&pIndices, D3DLOCK_READONLY)
//		, pVB->Unlock(); goto func_release_end);
//
//	// Y|ŜR_
//	pVec[0] = *(D3DXVECTOR3*)(pVertices + dwfvfSize * pIndices[0]);
//	pVec[1] = *(D3DXVECTOR3*)(pVertices + dwfvfSize * pIndices[1]);
//	pVec[2] = *(D3DXVECTOR3*)(pVertices + dwfvfSize * pIndices[2]);
//
//	// ߂R_@xNg߂
//	// [JWn
//	D3DXVECTOR3 v1 = pVec[1] - pVec[0];
//	D3DXVECTOR3 v2 = pVec[2] - pVec[0];
//
//	// |S̖@xNg߂
//	D3DXVec3Cross(pVec, &v1 , &v2);
//	// @xNg𐳋K
//	D3DXVec3Normalize(pVec, pVec);
//
//	pVB->Unlock();
//	pIB->Unlock();
//func_release_end:
//	pVB->Release();
//	pIB->Release();
//func_end:
//	return pVec;
//}

/**********************************************************************//**
 *
 * `O
 *
*//***********************************************************************/
void IDXMesh::PreDraw(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return;
	pDxDevice->SetRenderState(D3DRS_LIGHTING, IsRenderState(DXRS_ENABLELIGHT));
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void IDXMesh::Release(void)
{
}

/**********************************************************************//**
 *
 * _OXe[gݒ
 *
*//***********************************************************************/
void IDXMesh::SetupRenderState(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	D3DXMATRIX mat;
	D3DXMatrixIdentity(&mat);
	pDevice.SetTransform(D3DTS_TEXTURE0, &mat);

	DWORD cull = IsRenderState(DXRS_CULLFACE) ? DXCULL_FACE : D3DCULL_NONE;
	pDevice.SetRenderState(D3DRS_CULLMODE, cull);
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void IDXMesh::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void IDXMesh::Restore(void)
{
}

}	// end of namespace dx
}	// end of namespace iris
