//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXIndexBuffer.h
 * @brief		IndexBuffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXIndexBuffer_H_
#define INCG_IRIS_DXIndexBuffer_H_

//======================================================================
// include
#include "../DXObject.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @brief	o[ebNXobt@[NX
*/
class CDXIndexBuffer : virtual public IDXGXObject
{
public:
	typedef CDXDeviceObject<LPDXINDEXBUFFER>	INDEXBUFFER;
protected:
	INDEXBUFFER	m_lpIB;	//!< CfbNXobt@[
public:
	// RXgN^
	CDXIndexBuffer(void);
	// fXgN^
	virtual ~CDXIndexBuffer(void);

public:
	// 쐬
	bool	Create(UINT uLength, DWORD dwUsage, DXFORMAT Format, DXPOOL Pool);

public:
	//! 쐬
	virtual bool	Create(void) { return true; }
	// 
	virtual	void	Release(void);

protected:
	//! Zbg
	virtual	void	Reset(void)		{}
	//! XgA
	virtual	void	Restore(void)	{}

public:
	// foCXɊ֘At
	HRESULT	SetIndices(void);

public:
	// bN
	HRESULT	Lock(void** ppbData, UINT uOffset=0, UINT uSize=0, DWORD dwFlags=0);
	// AbN
	HRESULT	Unlock(void);

public:
	const INDEXBUFFER&	GetIndexBuffer(void) const	{ return m_lpIB; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
