//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMaterial.h
 * @brief		}eANXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMaterial_H_
#define INCG_IRIS_DXMaterial_H_

//======================================================================
// include
#include "iris_object.h"
#include "../../dx_inchead.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/// }eANX
class CDXMaterial : public IIrisObject, public intr::DXIMATERIAL
{
public:
	// RXgN^
	CDXMaterial(  const intr::DXICOLOR& diffuse		= intr::DXICOLOR(1.0f, 1.0f, 1.0f, 1.0f)
				, const intr::DXICOLOR& ambient		= intr::DXICOLOR(0.0f, 0.0f, 0.0f, 0.0f)
				, const intr::DXICOLOR& specular	= intr::DXICOLOR(0.0f, 0.0f, 0.0f, 0.0f)
				, const intr::DXICOLOR& emissive	= intr::DXICOLOR(0.0f, 0.0f, 0.0f, 0.0f)
				, f32 power = 0.0f
				);

public:
	// Diffuse̎擾
			intr::DXICOLOR&	GetDiffuse(void)					{ return Diffuse; }
	const	intr::DXICOLOR&	GetDiffuse(void)		const		{ return Diffuse; }
	// Diffuse̐ݒ
	void			SetDiffuse(const intr::DXICOLOR& diffuse)	{ Diffuse = diffuse; }
	void			SetDiffuse(f32 r, f32 g, f32 b, f32 a);

	// Ambient̎擾
			intr::DXICOLOR&	GetAmbient(void)					{ return Ambient; }
	const	intr::DXICOLOR&	GetAmbient(void)		const		{ return Ambient; }
	// Ambient̐ݒ
	void			SetAmbient(const intr::DXICOLOR& ambient)	{ Ambient = ambient; }
	void			SetAmbient(f32 r, f32 g, f32 b, f32 a);

	// Specular̎擾
			intr::DXICOLOR&	GetSpecular(void)					{ return Specular; }
	const	intr::DXICOLOR&	GetSpecular(void)		const		{ return Specular; }
	// Specular̐ݒ
	void			SetSpecular(const intr::DXICOLOR& specular)	{ Specular = specular; }
	void			SetSpecular(f32 r, f32 g, f32 b, f32 a);

	// Emissive̐ݒ
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
			intr::DXICOLOR&	GetEmissive(void)					{ return Emissive; }
	const	intr::DXICOLOR&	GetEmissive(void)		const		{ return Emissive; }
	void			SetEmissive(const intr::DXICOLOR& emissive)	{ Emissive = emissive; }
#else
	void			SetEmissive(const intr::DXICOLOR&)	{}
#endif
	void			SetEmissive(f32 r, f32 g, f32 b, f32 a);

	/// Power̎擾
	f32				GetPower(void)		const	{ return Power; }
	/// Power̐ݒ
	void			SetPower(f32 pow)			{ Power = pow; }
};


}	// end of namespace dx
}	// end of namespace iris

#endif
