//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXLight.cpp
 * @brief		directX Cgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXLight_CPP_

//======================================================================
// include
#include "DXLight.h"
#include "../DXDevice.h"

#include "../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXLight::CDXLight(void)
: m_bEnable(true)
, m_dwIdx(0)
{
	ZeroMemory(&m_Light, sizeof(m_Light));
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pLight	= DXLIGHT
*//***********************************************************************/
CDXLight::CDXLight(LPDXLIGHT pLight, DWORD idx)
: m_bEnable(true)
, m_dwIdx(idx)
{
	ZeroMemory(&m_Light, sizeof(m_Light));
	SetLight(pLight);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXLight::~CDXLight(void)
{
	Release();
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXLight::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXLight::Draw(void)
{
	Activate();
}

/**********************************************************************//**
 *
 * Cgݒ
 *
*//***********************************************************************/
void CDXLight::Activate(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	pDevice->LightEnable(m_dwIdx, m_bEnable);
	if( m_bEnable )
		pDevice.SetLight(m_dwIdx, &m_Light);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXLight::Release(void)
{
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXLight::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXLight::Restore(void)
{
	Activate();
}

/**********************************************************************//**
 *
 * Diffuse ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXLight::SetDiffuse(f32 r, f32 g, f32 b, f32 a)
{
	m_Light.Diffuse.r = (DXVALUE)r;
	m_Light.Diffuse.g = (DXVALUE)g;
	m_Light.Diffuse.b = (DXVALUE)b;
	m_Light.Diffuse.a = (DXVALUE)a;
}

/**********************************************************************//**
 *
 * Specular ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXLight::SetSpecular(f32 r, f32 g, f32 b, f32 a)
{
	m_Light.Specular.r = (DXVALUE)r;
	m_Light.Specular.g = (DXVALUE)g;
	m_Light.Specular.b = (DXVALUE)b;
	m_Light.Specular.a = (DXVALUE)a;
}

/**********************************************************************//**
 *
 * Ambient ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	r	= r
 * @param [in]	g	= g
 * @param [in]	b	= b
 * @param [in]	a	= a
*//***********************************************************************/
void CDXLight::SetAmbient(f32 r, f32 g, f32 b, f32 a)
{
	m_Light.Ambient.r = (DXVALUE)r;
	m_Light.Ambient.g = (DXVALUE)g;
	m_Light.Ambient.b = (DXVALUE)b;
	m_Light.Ambient.a = (DXVALUE)a;
}

/**********************************************************************//**
 *
 * Position ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @param [in]	z	= zW
*//***********************************************************************/
void CDXLight::SetPositon(f32 x, f32 y, f32 z)
{
	m_Light.Position.x = (DXVALUE)x;
	m_Light.Position.y = (DXVALUE)y;
	m_Light.Position.z = (DXVALUE)z;
}

/**********************************************************************//**
 *
 * Position ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @param [in]	z	= zW
*//***********************************************************************/
void CDXLight::SetDirection(f32 x, f32 y, f32 z)
{
	D3DXVECTOR3	vec(x, y, z);
	D3DXVec3Normalize(&vec, &vec);
	m_Light.Direction.x = (DXVALUE)vec.x;
	m_Light.Direction.y = (DXVALUE)vec.y;
	m_Light.Direction.z = (DXVALUE)vec.z;
}

}	// end of namespace dx
}	// end of namespace iris
