//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXLayerObject.h
 * @brief		C[o^\IuWFNgNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXLayerObject_H_
#define INCG_IRIS_DXLayerObject_H_

//======================================================================
// include
#include "../DXObject.h"
#include "fnd/types/FndExecutor.h"

namespace iris {
namespace dx
{

//======================================================================
// class

/**
 * @brief	C[o^\IuWFNgNX
*/
class IDXLayerObject : public fnd::CExecutor, virtual public IDXGXObject
{
public:
	// RXgN^
	IDXLayerObject(void);
	// fXgN^
	virtual ~IDXLayerObject(void);
public:
	//! XV
	virtual void	Update(f32 time) = 0;
	//! `O
	virtual	void	PreDraw(void)	{}
	//! `
	virtual	void	Draw(void) = 0;
	//! `㏈
	virtual	void	PostDraw(void)	{}

public:
	//! [h}gbNX̐ݒ
	virtual	void			SetWorldMatrix(LPD3DXMATRIX /*pmat*/)	{}
	//! [h}gbNX̎擾
	virtual	LPD3DXMATRIX	GetWorldMatrix(void)					{ return nullptr; }

	//! [hW̐ݒ
	virtual	void			SetWorldPos(const D3DXVECTOR3* /*pos*/)	{}
};

/**
 * @brief	}gbNXt IDXLayerObject
*/
class IDXMtxLayerObject : virtual public IDXLayerObject
{
protected:
	D3DXMATRIX			m_Mtx;	//!< }gbNX
public:
	/// RXgN^
	IDXMtxLayerObject(void)
		: m_Mtx(D3DXMATRIX(	  1.0f, 0.0f, 0.0f, 0.0f
							, 0.0f, 1.0f, 0.0f, 0.0f
							, 0.0f, 0.0f, 1.0f, 0.0f
							, 0.0f, 0.0f, 0.0f, 1.0f))
	{}
	/// fXgN^
	//virtual ~IDXMtxLayerObject(void) {}
public:
	// set,get
	virtual	void			SetWorldMatrix(LPD3DXMATRIX pmat)	{ m_Mtx = *pmat; }
	virtual	LPD3DXMATRIX	GetWorldMatrix(void)				{ return &m_Mtx; }

	virtual	void		SetWorldPos(const D3DXVECTOR3* pos)	{ m_Mtx._41 = pos->x; m_Mtx._42 = pos->y; m_Mtx._43 = pos->z; }
	virtual	void		GetWorldPos(	  D3DXVECTOR3* pos)	{ pos->x = m_Mtx._41; pos->y = m_Mtx._42; pos->z = m_Mtx._43; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
