//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGdiFont.h
 * @brief		directX GDI gptHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXGdiFont_H_
#define INCG_IRIS_DXGdiFont_H_

//======================================================================
// include
#include "DXFontTexture.h"
#include "../../../win/gdi/WXWndDC.h"
#include "../../../win/gdi/WXGdiFont.h"
#include "../../../win/gdi/WXGdiBitmap.h"
#include "../../../win/gdi/WXGdiBrush.h"
#include "../../../win/gdi/WXGdiPen.h"

namespace iris {
namespace dx
{

//======================================================================
//! Gdi tHgNXx[X
class IDXGdiFontBase : public IDXFontTexture
{
protected:
	wx::CGDIFont	m_hFont;		//!< tHg

	bool			m_bAntialias;	//!< A`GCAX

public:
	// RXgN^
	IDXGdiFontBase(void);
	// fXgN^
	virtual ~IDXGdiFontBase(void);
public:
	// eNX`쐬
	virtual bool	Create(UINT width, UINT height);
	// 
	virtual void	Release(void);

public:
	// ̈̃NA
	virtual void	Clear(void);

public:
	// tHg쐬
	virtual	bool	CreateFontA(int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCSTR  pszFaceName)
	{
		return CreateFontA( height, width, 0, 0, weight, bItalic, bUnderline, bStrikeOut
			, iCharSet, iOutputPrecision, CLIP_DEFAULT_PRECIS, iQuality, iPitchAndFamily, pszFaceName );
	}
	virtual	bool	CreateFontW(int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCWSTR pszFaceName)
	{
		return CreateFontW( height, width, 0, 0, weight, bItalic, bUnderline, bStrikeOut
			, iCharSet, iOutputPrecision, CLIP_DEFAULT_PRECIS, iQuality, iPitchAndFamily, pszFaceName );
	}
	bool			CreateFontA(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCSTR pszFaceName
						);
	bool			CreateFontW(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName
						);
	bool			CreateFontIndirectA( const LOGFONTA* lplf );
	bool			CreateFontIndirectW( const LOGFONTW* lplf );

	virtual bool	CreateFontFromInfoA( const CDXFontInfo* lpInfo ) { LOGFONTA lf; lpInfo->GetLogFontA(lf); return CreateFontIndirectA(&lf); }
	virtual bool	CreateFontFromInfoW( const CDXFontInfo* lpInfo ) { LOGFONTW lf; lpInfo->GetLogFontW(lf); return CreateFontIndirectW(&lf); }

	// tHg폜
	virtual void	DeleteFont(void);

	// tHgݒ
	//void	SetFont(HFONT hFont)			{ m_hFont = hFont; }
	// tHg擾
	HFONT	GetFont(void)	const			{ return m_hFont; }

public:
	// set, get
	void			SetAntialias(bool antialias)	{ m_bAntialias = antialias; }
	bool			GetAntialias(void)	const		{ return m_bAntialias; }


protected:
	// tHg쐬ʏ
	bool			OnCreateFont(void);
};

//! Gdi tHgNX
class CDXGdiFont : public IDXGdiFontBase
{
	static const COLORREF	clrBack		= RGB(0, 0, 255);
	static const COLORREF	clrFont		= RGB(255, 0, 0);
	static const COLORREF	clrOutline	= RGB(0, 255, 0);
protected:
	intr::DXICOLOR	m_EdgeColor;	//!< GbWF
	LONG			m_EdgeWidth;	//!< GbW̑
	s32				m_Quality;		//!< x

public:
	// RXgN^
	CDXGdiFont(void);
	// fXgN^
	virtual ~CDXGdiFont(void);
public:
	// GbWJ[
	void			SetEdgeColor(const intr::DXICOLOR& color)	{ m_EdgeColor = color; }
	intr::DXICOLOR	GetEdgeColor(void)	const					{ return m_EdgeColor; }

	// GbW
	void			SetEdgeWidth(LONG width)		{ m_EdgeWidth = width; }
	LONG			GetEdgeWidth(void)	const		{ return m_EdgeWidth; }

	// x
	void			SetQuality(s32 quality)			{ m_Quality = quality; }
	s32				GetQuality(void)	const		{ return m_Quality; }

public:
	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA(int x, int y, LPCSTR  pString, size_t size);
	virtual bool	TextOutW(int x, int y, LPCWSTR pString, size_t size);

protected:
	// eNX`ɃRs[
	bool	PasteTexture(const u8* buf);

protected:
	// tHg
	template<typename CHARTYPE_>
	bool	OnTextOut(int x, int y, const CHARTYPE_* pString, size_t size)
	{
		if( !m_hFont.IsValid() )
		{
			IRIS_WARNING( "HFONT is nullptr." );
			return false;
		}
		CDXDevice* pDxDevice = GetDXDevice();
		if( pDxDevice == nullptr || m_pTexture == nullptr || m_pSurface == nullptr ) return false;

		wx::CDeviceContext hDC;
		{
			LPCDXPRESENT_PARAMETERS pPresent = GetPresent();
			HWND hWnd = pPresent != nullptr ? pPresent->hDeviceWindow : nullptr;
			wx::CWndDC hWndDC(hWnd);
			hDC = hWndDC.CreateCompatibleDC();
		}

		RECT rc;
		GetRect(&rc);

        BITMAPINFO bmpInfo = {0};
        bmpInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bmpInfo.bmiHeader.biWidth = rc.right * m_Quality;
		bmpInfo.bmiHeader.biHeight = -rc.bottom * m_Quality;
        bmpInfo.bmiHeader.biPlanes = 1;
        bmpInfo.bmiHeader.biBitCount = 24;
        u8 *p = 0;

		wx::CGDIBitmap bmp;
		if( !bmp.CreateDIBSection(hDC, &bmpInfo, DIB_RGB_COLORS, pointer_cast<void**>(&p), nullptr, 0) ) return false;
		wx::CGDISelectObject hSelBmp(hDC, bmp);

		// hԂ
		{
			wx::CGDIBrush brush;
			if( !brush.CreateSolid(clrBack) ) return false;
			hDC.FillRect(&rc, brush);
		}

		{
			wx::CGDIBrush brush;
			if( !brush.CreateSolid(clrFont) ) return false;
			wx::CGDIPen pen;
			wx::CGDISelectObject hSelPen;
			if( m_EdgeWidth > 0 )
			{
				if( !pen.CreateSolid(m_EdgeWidth, clrOutline) ) return false;
				hSelPen.SelectObject(hDC, pen);
			}
			wx::CGDISelectObject hSelFont(hDC, m_hFont);
			wx::CGDISelectObject hSelBrush(hDC, brush);

			int bkMode = hDC.SetBkMode(TRANSPARENT);	// wil

			hDC.BeginPath();
			// `
			rc.left = x;
			rc.top = y;
			hDC.DrawText(&rc, 0, static_cast<int>(size), pString);

			hDC.EndPath();
			hDC.StrokeAndFillPath();

			hDC.SetBkMode(bkMode);
		}

		if( !PasteTexture(p) ) return false;
		return true;
	}
};

}	// end of namespace dx
}	// end of namespace iris

#endif
