//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGdiFont.cpp
 * @brief		directX GDI gptHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXGdiFont_CPP_

//======================================================================
// include
#include "DXGdiFont.h"
#include "../DXDevice.h"
#include "../DXSurface.h"
#include "../../DXError.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXGdiFontBase::IDXGdiFontBase(void)
: m_bAntialias(true)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXGdiFontBase::~IDXGdiFontBase(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ̈̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @return	
*//***********************************************************************/
bool IDXGdiFontBase::Create(UINT width, UINT height)
{
#if	defined(_IRIS_SUPPORT_DXMOBILE)
	if( !CDXTexture::CreateTexture(width, height, 1, D3DMUSAGE_LOCKABLE, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM) )
#endif
	{
		if( !CDXTexture::CreateTexture(width, height, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED) )
		{
			return false;
		}
	}
//#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#if 1
	DX_DO_CHECK_RESULT( m_pTexture->GetSurfaceLevel(0, &m_pSurface), return false );
#else
	IRIS_ASSERT( GetDXDevice() );
	DX_DO_CHECK_RESULT( GetDXDevice()->GetDevice()->CreateOffscreenPlainSurface(width, height, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM, &m_pSurface, nullptr), return false);
#endif
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void IDXGdiFontBase::Release(void)
{
	CDXTexture::Release();
	DeleteFont();
}

/**********************************************************************//**
 *
 * ̈̃NA
 *
*//***********************************************************************/
void IDXGdiFontBase::Clear(void)
{
	if( m_pTexture == nullptr ) return;
	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect(0, &TexRect, nullptr, 0);
	if( FAILED( hr ) ) { DX_ERROR( hr ); return; }

	memset(TexRect.pBits, 0x00, TexRect.Pitch*m_Height);
	m_pTexture->UnlockRect( 0 );
}

/**********************************************************************//**
 *
 * tHg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	height			= tHg
 * @param [in]	width			= 
 * @param [in]	escapement		= eLXg̊px
 * @param [in]	orientation		= x[XCƂƂ̊px
 * @param [in]	weight			= tHg̏dij
 * @param [in]	bItalic			= C^bN
 * @param [in]	bUnderline		= A_[C
 * @param [in]	bStrikeOut		= ł
 * @param [in]	iCharSet		= Zbg
 * @param [in]	iOutPrecision	= o͐x
 * @param [in]	iClipPrecision	= NbsOx
 * @param [in]	iQuality		= o͕i
 * @param [in]	iPitchAndFamily	= sb`ƃt@~[
 * @param [in]	pszFaceName		= ̖
 * @return	
*//***********************************************************************/
bool IDXGdiFontBase::CreateFontA(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCSTR pszFaceName
						)
{
#if !defined(IRIS_WIN32_WCE)
	LOGFONTA lf = {
		height,					// tHg
		width,					// 
		escapement,				// eLXg̊px
		orientation,			// x[XCƂƂ̊px
		weight,					// tHg̏dij
		(BYTE)bItalic,			// C^bN
		(BYTE)bUnderline,		// A_[C
		(BYTE)bStrikeOut,		// ł
		(BYTE)iCharSet,			// Zbg
		(BYTE)iOutPrecision,	// o͐x
		(BYTE)iClipPrecision,	// NbsOx
		(BYTE)iQuality,			// o͕i
		(BYTE)iPitchAndFamily,	// sb`ƃt@~[
		""						// ̖
	};
	strcpy_s(lf.lfFaceName, sizeof(lf.lfFaceName), pszFaceName);
	return CreateFontIndirectA( &lf );
#else
	return false;
#endif
}
/// IDXGdiFontBase::CreateFontA Q
bool IDXGdiFontBase::CreateFontW(int height, int width, int escapement, int orientation, int weight
						  , DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
						  , DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
						  , DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName
						)
{
	LOGFONTW lf = {
		height,					// tHg
		width,					// 
		escapement,				// eLXg̊px
		orientation,			// x[XCƂƂ̊px
		weight,					// tHg̏dij
		(BYTE)bItalic,			// C^bN
		(BYTE)bUnderline,		// A_[C
		(BYTE)bStrikeOut,		// ł
		(BYTE)iCharSet,			// Zbg
		(BYTE)iOutPrecision,	// o͐x
		(BYTE)iClipPrecision,	// NbsOx
		(BYTE)iQuality,			// o͕i
		(BYTE)iPitchAndFamily,	// sb`ƃt@~[
		L""						// ̖
	};
	wcscpy_s(lf.lfFaceName, sizeof(lf.lfFaceName)/sizeof(WCHAR), pszFaceName);
	return CreateFontIndirectW( &lf );
}

/**********************************************************************//**
 *
 * tHg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= tHg
 * @return	
*//***********************************************************************/
bool IDXGdiFontBase::CreateFontIndirectA(const LOGFONTA* lplf)
{
	if( m_hFont.IsValid() ) return false;
	m_hFont.CreateIndirect(lplf);
	return OnCreateFont();
}
/// IDXGdiFontBase::CreateFontIndirectA Q
bool IDXGdiFontBase::CreateFontIndirectW(const LOGFONTW* lplf)
{
	if( m_hFont.IsValid() ) return false;
	m_hFont.CreateIndirect(lplf);
	return OnCreateFont();
}

/**********************************************************************//**
 *
 * tHg
 *
*//***********************************************************************/
void IDXGdiFontBase::DeleteFont(void)
{
	m_hFont.Delete();
	m_FontWidth = -1;
	m_FontHeight = -1;
}

/**********************************************************************//**
 *
 * tHg쐬ʏ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool IDXGdiFontBase::OnCreateFont(void)
{
	if( !m_hFont.IsValid() ) return false;

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXPRESENT_PARAMETERS pPresent = GetPresent();
	HWND hWnd = pPresent != nullptr ? pPresent->hDeviceWindow : nullptr;
	wx::CWndDC hDC(hWnd);
#else
	HWND hWnd = nullptr;
	CDXSurfaceDC hSurfaceDC(m_pSurface);
	wx::CTemporaryDC hDC = hSurfaceDC.GetDC();
	wx::CWndDC hWndDC;
	if( hDC == nullptr )
	{
		wx::CWndDC hTempDC(hWnd);
		hWndDC = hTempDC;
		hDC = hWndDC.GetDC();
	}
#endif
	wx::CGDISelectObject selFont(hDC, m_hFont);

	// tHg擾
	TEXTMETRIC tm;
	hDC.GetTextMetrics(&tm);
	m_FontWidth = tm.tmMaxCharWidth;
	m_FontHeight= tm.tmHeight + tm.tmExternalLeading*2;
	return true;
}


//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXGdiFont::CDXGdiFont(void)
: m_EdgeColor(0x0)
, m_EdgeWidth(0)
, m_Quality(1)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXGdiFont::~CDXGdiFont(void)
{
}

/**********************************************************************//**
 *
 * `
 *
 ----------------------------------------------------------------------
 * @param [in]	x, y			= `ʒu
 * @param [in]	pString			= 
 * @param [in]	size			= 
 * @return	
*//***********************************************************************/
bool CDXGdiFont::TextOutA(int x, int y, LPCSTR  pString, size_t size)
{
	return OnTextOut(x, y, pString, size);
}
/// CDXGdiFont::TextOutA Q
bool CDXGdiFont::TextOutW(int x, int y, LPCWSTR pString, size_t size)
{
	return OnTextOut(x, y, pString, size);
}

/**********************************************************************//**
 *
 * eNX`ɃRs[
 *
 ----------------------------------------------------------------------
 * @param [in]	buf	= bitmap obt@
 * @return	
*//***********************************************************************/
bool CDXGdiFont::PasteTexture(const u8* buf)
{
	if( m_pTexture == nullptr ) return false;
	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect(0, &TexRect, nullptr, 0);
	if( FAILED( hr ) ) return false;

	const UINT fontPitch = roundup(m_Width*m_Quality*3, 4);
	const INT pitch = TexRect.Pitch/4;
	u32* d = static_cast<u32*>(TexRect.pBits);
	const s32 q2 = m_Quality * m_Quality;
	for( UINT y=0; y < m_Height; ++y, d+=pitch )
	{
		u32* p = d;
		for( UINT x=0; x < m_Width; ++x, ++p )
		{
			u8 alpha = 0;
			u8 edge  = 0;
			u8 fill  = 0;
			for( s32 i=0; i < m_Quality; ++i )
			{
				for( s32 j=0; j < m_Quality; ++j )
				{
					alpha += buf[(y * m_Quality + i)*fontPitch + (x * m_Quality + j) * 3 + 0];
					edge  += buf[(y * m_Quality + i)*fontPitch + (x * m_Quality + j) * 3 + 1];
					fill  += buf[(y * m_Quality + i)*fontPitch + (x * m_Quality + j) * 3 + 2];
				}
			}
			u8 a = 0xFF - alpha;
			if( a < 0xFF )
			{
				u32 clra = static_cast<u32>(m_EdgeColor.a * a) & 0xFF;
				DWORD clr = m_EdgeColor;
				*p = (clr & 0x00FFFFFF) | (clra << 24);
			}
			else
			{
				u32 clrr = (static_cast<u32>(m_EdgeColor.r * edge) + static_cast<u32>(m_FontColor.r * fill) ) & 0xFF;
				u32 clrg = (static_cast<u32>(m_EdgeColor.g * edge) + static_cast<u32>(m_FontColor.g * fill) ) & 0xFF;
				u32 clrb = (static_cast<u32>(m_EdgeColor.b * edge) + static_cast<u32>(m_FontColor.b * fill) ) & 0xFF;
				u32 clra = (static_cast<u32>(m_EdgeColor.a * edge) + static_cast<u32>(m_FontColor.a * fill) ) & 0xFF;
				*p = (clra << 24) | (clrr << 16) | (clrg << 8) | (clrb);
			}
		}
	}

   m_pTexture->UnlockRect( 0 );
   return true;
}


}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/DXDebugUnitTest.h"
#include "../DXObjectManager.h"
#include "../scene/DXCamera.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST_B(CDXGdiFontUnitTest, iris::dx::dbg::CDXUnitTestBase, Func)
{
	HWND hWnd = nullptr;

	RECT src = {0, 0, 640, 480};

	// EBhEg̒
	AdjustWindowRectEx(&src, WINDOW_STYLE, FALSE, WINDOW_STYLEEX);

	hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX, m_TestName, m_TestName, WINDOW_STYLE
		, src.right, src.bottom, DrawTestWindowProc);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		return;

	ShowWindow( hWnd, SW_HIDE );
	CDXDevice dev(hWnd);
	CDXObjectManager objMan(&dev.GetDXSwapChain());
	if( !dev.CreateDevice(src.right, src.bottom, false, false, false, false, false, false) )
	{
		return;
	}
	dev.CreateSprite();
	objMan.CreateLayer<CDXDefaultLayer>(0);
	//CDXCamera* pCamera = devEx.CreateObject<CDXCamera>();
	//pCamera->SetPos(D3DXVECTOR3(0.0f, 0.0f, -10.0f));
	//pCamera->SetViewport();
	//pCamera->Activate();

	CDXGdiFont* pFont = objMan.CreateLayerObject<CDXGdiFont>(0);

	CHAR buf[256] = "TEST";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "͂ĂB" << std::endl;
	std::cin >> buf;
#endif

	pFont->Create(src.right, src.bottom);
	pFont->CreateFont(400*4, 0, FW_NORMAL, 0, 0, 0
		, SHIFTJIS_CHARSET
		, OUT_TT_PRECIS
		, PROOF_QUALITY
		, FIXED_PITCH | FF_MODERN
		, TEXT("lr ") );
	pFont->Clear();
	pFont->SetQuality(4);
	pFont->SetEdgeWidth(2*4);
	pFont->SetEdgeColor(0x7FFF0000);
	pFont->SetFontColor(0xFF22FF22);
	pFont->TextOutA(0, 0, buf, strlen(buf) );
	pFont->EnableRenderState(DXRS_DRAWSPRITE);
	pFont->SetWorldPos( &D3DXVECTOR3(0.0f, 0.0f, 0.0f) );

	this->SetDevice(&dev);

	// EBhE`
	ShowWindow( hWnd, SW_SHOW );
	// EBhE̍XV
	UpdateWindow( hWnd );
	// őOʂ
	SetForegroundWindow(hWnd);

	wx::dbg::UnitTestMainLoop(hWnd);
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
