//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFontInfo.cpp
 * @brief		directX tHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXFontInfo_CPP_

//======================================================================
// include
#include "DXFontInfo.h"

namespace iris {
namespace dx
{

//======================================================================
// class

//======================================================================
// CDXFontInfo
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXFontInfo::CDXFontInfo(void)
: Height(12)
, Width(0)
, Escapement(0)
, Orientation(0)
, Weight(FW_NORMAL)
, Italic(0)
, Underline(0)
, StrikeOut(0)
, CharSet(SHIFTJIS_CHARSET)
, OutPrecision(OUT_TT_PRECIS)
, ClipPrecision(CLIP_DEFAULT_PRECIS)
, Quality(PROOF_QUALITY)
, PitchAndFamily(FIXED_PITCH | FF_MODERN)
, MipLevels(1)
{
	ZeroMemory(FaceNameA, sizeof(FaceNameA));
	ZeroMemory(FaceNameW, sizeof(FaceNameW));
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	lf = LOGFONTA
*//***********************************************************************/
CDXFontInfo::CDXFontInfo(const LOGFONTA& lf)
: MipLevels(1)
{
	SetLogFontA(lf);
	ZeroMemory(FaceNameW, sizeof(FaceNameW));
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	lf = LOGFONTW
*//***********************************************************************/
CDXFontInfo::CDXFontInfo(const LOGFONTW& lf)
: MipLevels(1)
{
	SetLogFontW(lf);
	ZeroMemory(FaceNameA, sizeof(FaceNameA));
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	fd = DXFONT_DESCA
*//***********************************************************************/
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
CDXFontInfo::CDXFontInfo(const DXFONT_DESCA& fd)
: Escapement(0)
, Orientation(0)
, Underline(0)
, StrikeOut(0)
, ClipPrecision(CLIP_DEFAULT_PRECIS)
{
	SetFontDescaA(fd);
	ZeroMemory(FaceNameW, sizeof(FaceNameW));
}
#endif

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	fd = DXFONT_DESCW
*//***********************************************************************/
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
CDXFontInfo::CDXFontInfo(const DXFONT_DESCW& fd)
: Escapement(0)
, Orientation(0)
, Underline(0)
, StrikeOut(0)
, ClipPrecision(CLIP_DEFAULT_PRECIS)
{
	SetFontDescaW(fd);
	ZeroMemory(FaceNameA, sizeof(FaceNameA));
}
#endif

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXFontInfo::~CDXFontInfo(void)
{
}

/**********************************************************************//**
 *
 * LOGFONTݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lf = LOGFONT
 * @return	this reference
*//***********************************************************************/
CDXFontInfo& CDXFontInfo::SetLogFontA(const LOGFONTA& lf)
{
	Height			= lf.lfHeight;
	Width			= lf.lfWidth;
	Escapement		= lf.lfEscapement;
	Orientation		= lf.lfOrientation;
	Weight			= lf.lfWeight;
	Italic			= lf.lfItalic;
	Underline		= lf.lfUnderline;
	StrikeOut		= lf.lfStrikeOut;
	CharSet			= lf.lfCharSet;
	OutPrecision	= lf.lfOutPrecision;
	ClipPrecision	= lf.lfClipPrecision;
	Quality			= lf.lfQuality;
	PitchAndFamily	= lf.lfPitchAndFamily;
	memcpy( FaceNameA , lf.lfFaceName, sizeof(lf.lfFaceName));
	return *this;
}
/// CDXFontInfo::SetLogFontA Q
CDXFontInfo& CDXFontInfo::SetLogFontW(const LOGFONTW& lf)
{
	Height			= lf.lfHeight;
	Width			= lf.lfWidth;
	Escapement		= lf.lfEscapement;
	Orientation		= lf.lfOrientation;
	Weight			= lf.lfWeight;
	Italic			= lf.lfItalic;
	Underline		= lf.lfUnderline;
	StrikeOut		= lf.lfStrikeOut;
	CharSet			= lf.lfCharSet;
	OutPrecision	= lf.lfOutPrecision;
	ClipPrecision	= lf.lfClipPrecision;
	Quality			= lf.lfQuality;
	PitchAndFamily	= lf.lfPitchAndFamily;
	memcpy( FaceNameW , lf.lfFaceName, sizeof(lf.lfFaceName));
	return *this;
}

/**********************************************************************//**
 *
 * LOGFONT擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lf = o
*//***********************************************************************/
void CDXFontInfo::GetLogFontA(LOGFONTA &lf) const
{
	lf.lfHeight			= Height;
	lf.lfWidth			= Width;
	lf.lfEscapement		= Escapement;
	lf.lfOrientation	= Orientation;
	lf.lfWeight			= Weight;
	lf.lfItalic			= Italic;
	lf.lfUnderline		= Underline;
	lf.lfStrikeOut		= StrikeOut;
	lf.lfCharSet		= CharSet;
	lf.lfOutPrecision	= OutPrecision;
	lf.lfClipPrecision	= ClipPrecision;
	lf.lfQuality		= Quality;
	lf.lfPitchAndFamily	= PitchAndFamily;
	memcpy( lf.lfFaceName, FaceNameA , sizeof(FaceNameA));
}
/// CDXFontInfo::GetLogFontA Q
void CDXFontInfo::GetLogFontW(LOGFONTW &lf) const
{
	lf.lfHeight			= Height;
	lf.lfWidth			= Width;
	lf.lfEscapement		= Escapement;
	lf.lfOrientation	= Orientation;
	lf.lfWeight			= Weight;
	lf.lfItalic			= Italic;
	lf.lfUnderline		= Underline;
	lf.lfStrikeOut		= StrikeOut;
	lf.lfCharSet		= CharSet;
	lf.lfOutPrecision	= OutPrecision;
	lf.lfClipPrecision	= ClipPrecision;
	lf.lfQuality		= Quality;
	lf.lfPitchAndFamily	= PitchAndFamily;
	memcpy( lf.lfFaceName, FaceNameW , sizeof(FaceNameW));
}

/**********************************************************************//**
 *
 * D3DXFONT_DESCݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	fd = D3DXFONT_DESC
 * @return	this reference
*//***********************************************************************/
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
CDXFontInfo& CDXFontInfo::SetFontDescaA(const DXFONT_DESCA& fd)
{
	Height			= fd.Height;
	Width			= fd.Width;
	Weight			= fd.Weight;
	MipLevels		= fd.MipLevels;
	Italic			= static_cast<BYTE>(fd.Italic);
	CharSet			= fd.CharSet;
	OutPrecision	= fd.OutputPrecision;
	Quality			= fd.Quality;
	PitchAndFamily	= fd.PitchAndFamily;
	memcpy( FaceNameA , fd.FaceName, sizeof(fd.FaceName));
	return *this;
}
/// CDXFontInfo::SetFontDescaA Q
CDXFontInfo& CDXFontInfo::SetFontDescaW(const DXFONT_DESCW& fd)
{
	Height			= fd.Height;
	Width			= fd.Width;
	Weight			= fd.Weight;
	MipLevels		= fd.MipLevels;
	Italic			= static_cast<BYTE>(fd.Italic);
	CharSet			= fd.CharSet;
	OutPrecision	= fd.OutputPrecision;
	Quality			= fd.Quality;
	PitchAndFamily	= fd.PitchAndFamily;
	memcpy( FaceNameW , fd.FaceName, sizeof(fd.FaceName));
	return *this;
}
#endif

/**********************************************************************//**
 *
 * D3DXFONT_DESC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	fd = D3DXFONT_DESC
*//***********************************************************************/
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
void CDXFontInfo::GetFontDescaA(DXFONT_DESCA& fd) const
{
	fd.Height			= Height;
	fd.Width			= Width;
	fd.Weight			= Weight;
	fd.MipLevels		= MipLevels;
	fd.Italic			= Italic;
	fd.CharSet			= CharSet;
	fd.OutputPrecision	= OutPrecision;
	fd.Quality			= Quality;
	fd.PitchAndFamily	= PitchAndFamily;
	memcpy( fd.FaceName, FaceNameA , sizeof(FaceNameA));
}
/// CDXFontInfo::GetFontDescaA Q
void CDXFontInfo::GetFontDescaW(DXFONT_DESCW& fd) const
{
	fd.Height			= Height;
	fd.Width			= Width;
	fd.Weight			= Weight;
	fd.MipLevels		= MipLevels;
	fd.Italic			= Italic;
	fd.CharSet			= CharSet;
	fd.OutputPrecision	= OutPrecision;
	fd.Quality			= Quality;
	fd.PitchAndFamily	= PitchAndFamily;
	memcpy( fd.FaceName, FaceNameW , sizeof(FaceNameW));
}
#endif

/**********************************************************************//**
 *
 * SetFaceName
 *
 ----------------------------------------------------------------------
 * @param [in]	facename = tHg
 * @return	this reference
*//***********************************************************************/
CDXFontInfo& CDXFontInfo::SetFaceNameA(LPCSTR  facename)
{
	strcpy_s( FaceNameA, sizeof(FaceNameA), facename );
	return *this;
}
/// CDXFontInfo::SetFaceNameA Q
CDXFontInfo& CDXFontInfo::SetFaceNameW(LPCWSTR facename)
{
	wcscpy_s( FaceNameW, sizeof(FaceNameW)/sizeof(WCHAR), facename );
	return *this;
}

}	// end of namespace dx
}	// end of namespace iris
