//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFade.h
 * @brief		directX tF[hNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFade_H_
#define INCG_IRIS_DXFade_H_

//======================================================================
// include
#include "DXColorFilter.h"
#include "fnd/utility/FndFade.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class
//! tF[hNX
class CDXFade : public CDXColorFilter, public fnd::IFade
{
public:
	// RXgN^
	CDXFade(void);
	// fXgN^
	~CDXFade(void);
public:
	/// XV
	virtual void		Update(f32 time)					{ IFade::Update(time); }
	// `
	virtual void		Draw(void);

public:
	// J[ݒ
	virtual void		_ChangeFadeColor(void)					{ m_Color = intr::DXICOLOR(m_fR, m_fG, m_fB, m_fA); }
	virtual	void		SetColor(const intr::DXICOLOR& color)	{ SetFadeColor(color); }

};

}	// end of namespace dx
}	// end of namespace iris

#endif
