//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXColorFilter.h
 * @brief		directX PFtB^[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXColorFilter_H_
#define INCG_IRIS_DXColorFilter_H_

//======================================================================
// include
#include "DXFilter.h"
#include "../sprite/DXSpriteTexture.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class
//! J[tB^[NX
class CDXColorFilter : public CDXFilter<CDXSpriteTexture>
{
	static const int	FILTER_TEX_SIZE = 32;
	typedef CDXFilter<CDXSpriteTexture>	_Mybase;
public:
	// RXgN^
	CDXColorFilter(void);
	// fXgN^
	virtual ~CDXColorFilter(void);
public:
	// 쐬
	virtual bool	Create(void);

private:
	// B
	virtual bool	CreateTexture(UINT, UINT, UINT, DWORD, D3DFORMAT, D3DPOOL) { return false; }
	virtual	bool	Load(const char* path, intr::DXICOLOR remColor=0xFF000000, UINT width=0, UINT height=0, UINT mipmaplevel=1, DWORD usage=0
							, DWORD filter = D3DX_FILTER_NONE, DWORD mipFilter=D3DX_DEFAULT
							, DXIMAGE_INFO* srcInfo=nullptr, PALETTEENTRY* pltEntry=nullptr)
	{
		IRIS_UNUSED_VARIABLE(path);			IRIS_UNUSED_VARIABLE(remColor);		IRIS_UNUSED_VARIABLE(width);
		IRIS_UNUSED_VARIABLE(height);		IRIS_UNUSED_VARIABLE(mipmaplevel);	IRIS_UNUSED_VARIABLE(usage);
		IRIS_UNUSED_VARIABLE(filter);		IRIS_UNUSED_VARIABLE(mipFilter);	IRIS_UNUSED_VARIABLE(srcInfo);
		IRIS_UNUSED_VARIABLE(pltEntry);
		return false;
	}
};

}	// end of namespace dx
}	// end of namespace iris

#endif
