//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXColorFilter.cpp
 * @brief		directX PFtB^[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXColorFilter_CPP_

//======================================================================
// include
#include "DXColorFilter.h"
#include "../texture/DXTexture.h"
#include "../DXDevice.h"
#include "../../DXError.h"

#include "../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
// CDXColorFilter
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXColorFilter::CDXColorFilter(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXColorFilter::~CDXColorFilter(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXColorFilter::Create(void)
{
	if( !_Mybase::Create() ) return false;

	CDXTexture texture;
	RegisterChain(&texture);
	if( !texture.CreateTexture(FILTER_TEX_SIZE, FILTER_TEX_SIZE, 1, 0,
							D3DFMT_A4R4G4B4, D3DPOOL_MANAGED) ) return false;
	SetTexture(&texture);

	DXLOCKED_RECT TexRect;
	HRESULT hr = m_pTexture->LockRect( 0, &TexRect, nullptr, 0 );
	if( FAILED( hr ) ) { DX_ERROR2( hr, "m_pTexture->LockRect" ); return false; }

	memset( TexRect.pBits, 0xFF, TexRect.Pitch*m_Height );
	m_pTexture->UnlockRect( 0 );

	FitBackBufferSize();
	return true;
}

}	// end of namespace dx
}	// end of namespace iris
