//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXGammaRamp.cpp
 * @brief		directX K}vt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXGammaRamp_CPP_

//======================================================================
// include
#include "DXGammaRamp.h"
#include "../DXDevice.h"
#include "../../DXError.h"

namespace iris {
namespace dx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * K}
 *
 ----------------------------------------------------------------------
 * @param [in]	gamma	= l
 * @param [in]	index	= ʒu
 * @return	K}l
*//***********************************************************************/
WORD DXGammaCurveLiner(WORD gamma, int index)
{
	return (WORD)(gamma*index);
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXGammaRamp::CDXGammaRamp(void)
{
	SetGamma(0, nullptr);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXGammaRamp::~CDXGammaRamp(void)
{
	Release();
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXGammaRamp::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXGammaRamp::Draw(void)
{
	Activate();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXGammaRamp::Release(void)
{
}

/**********************************************************************//**
 *
 * Activate
 *
*//***********************************************************************/
void CDXGammaRamp::Activate(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	pDevice->SetGammaRamp( 0, D3DSGR_CALIBRATE, &m_Gamma);
}

/**********************************************************************//**
 *
 * K}lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	gamma	= K}l
 * @param [in]	func	= ֐
*//***********************************************************************/
void CDXGammaRamp::SetGamma(WORD gamma, PFN_DXGammaCurve func)
{
	for( int i=0; i < 256; ++i )
	{
		WORD _gamma = gamma;
		if( func != nullptr )	_gamma = (*func)(gamma, i);
		m_Gamma.red[i]		= _gamma;
		m_Gamma.green[i]	= _gamma;
		m_Gamma.blue[i]		= _gamma;
	}
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXGammaRamp::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXGammaRamp::Restore(void)
{
}

}	// end of namespace dx
}	// end of namespace iris
