//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSwapChain.h
 * @brief		Xbv`FCNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXSwapChain_H_
#define INCG_IRIS_DXSwapChain_H_

//======================================================================
// include
#include "layer/DXLayer.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXDefaultSwapChain;
class CDXSwapChain;

//======================================================================
// class
/// Xbv`FCNXC^[tFCX
class IDXSwapChain : public IDXGXObject
{
	friend class CDXDevice;
	friend class IDXGXObject;
	friend class IDXLayerObject;
public:
	typedef	std::vector<IDXGXObject*>		vecObj;
protected:
	LPDXSWAPCHAIN	m_pDxSwapChain;	//!< Xbv`FC
	LPDXSURFACE		m_pBackBuffer;	//!< Xbv`FC̃obNobt@
protected:
	// IuWFNgXg
	vecObj					m_Objects;
	CDXLayerMgr				m_Layer;		//!< C[

public:
	// RXgN^
	IDXSwapChain(void);
	// fXgN^
	virtual ~IDXSwapChain(void);
public:
	// XV
	virtual void	Update(f32 time);
	// 
	virtual	void	Release(void);
	// ̈̍XV
	virtual bool	ReSize(UINT width, UINT height) = 0;
protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);

public:

	// `
	virtual	void	Draw(void);
	// `̊Jn
	virtual	bool	BeginScene(D3DCOLOR color=0xff101080, bool backbuffer=true, bool zbuffer=true);
	// `̏I
	virtual bool	EndScene(void);
	// ]
	virtual	bool	Present(const RECT* pSrcRect=nullptr);
	// ]
	virtual	bool	PresentOverride(const RECT* pSrcRect=nullptr, HWND hDestWindowOverride=nullptr);

public:
	//
	// object
	/// IuWFNg̍쐬
	template<class _TC>
	_TC*		CreateObject(void)
	{
		_TC* p = new _TC;
		if( !RegisterDeviceObject(p) )
		{
			DX_SAFE_DELETE(p);
			return nullptr;
		}
		return p;
	}

	// IuWFNg̓o^
	bool		RegisterDeviceObject(IDXGXObject* obj);
	// IuWFNg̍폜
	bool		EraseDeviceObject(IDXGXObject* obj);

	// C[ɃIuWFNgǉ
	bool		RegisterLayerObject(int LayerID, IDXLayerObject* obj)
						{ return m_Layer.RegisterLayerObject(LayerID, obj); }
	// C[IuWFNg폜
	bool		EraseLayerObject(int LayerID, IDXLayerObject* obj)
						{ return m_Layer.EraseLayerObject(LayerID, obj); }

	// IuWFNg̓o^ + C[ɃIuWFNgǉ
	bool		RegisterObject(int LayerID, IDXLayerObject* obj)
						{ if( !RegisterDeviceObject(obj) ) return false; return RegisterLayerObject(LayerID, obj); }
	// IuWFNg̍폜 + C[IuWFNg폜
	bool		EraseObject(int LayerID, IDXLayerObject* obj)
						{ bool ret = EraseDeviceObject(obj); ret &= EraseLayerObject(LayerID, obj); return ret; }
private:
	// C[狭폜
	void		EraseLayerObjectForce(IDXLayerObject* obj);

public:
	//
	// Layer

	// C[̒ǉ
	bool		RegisterLayer(int LayerID, IDXLayer* layer);
	// C[̍폜
	bool		EraseLayer(int LayerID)		{ return m_Layer.EraseLayer(LayerID); }		//!< call CDXLayerMgr::EraseLayer.
	bool		EraseLayer(IDXLayer* layer)	{ return m_Layer.EraseLayer(layer); }		//!< call CDXLayerMgr::EraseLayer.
	void		EraseLayerAll(void)			{ m_Layer.EraseLayerAll(); }				//!< call CDXLayerMgr::EraseLayerAll.
	// C[̍폜ideletej
	bool		ReleaseLayer(int LayerID)	{ return m_Layer.ReleaseLayer(LayerID); }	//!< call CDXLayerMgr::ReleaseLayer.
	void		ReleaseLayerAll(void)		{ m_Layer.ReleaseLayerAll(); }				//!< call CDXLayerMgr::ReleaseLayerAll.

	// C[̎擾
	IDXLayer*	GetLayer(int LayerID)	const	{ return m_Layer.GetLayer(LayerID); }		//!< call CDXLayerMgr::GetLayer.

	// C[Ǘ̎擾
	CDXLayerMgr&	GetLayerMgr(void)		{ return m_Layer; }

public:
	virtual HWND								GetHWND(void) const;
	// present
	virtual LPCDXPRESENT_PARAMETERS const		GetPresent(void) const;

public:
	// Device Context
	HRESULT		GetDC(HDC* phdc) const;
	HRESULT		ReleaseDC(HDC hdc);
};

/// ftHgXbv`F[NX
class CDXDefaultSwapChain : public IDXSwapChain
{
public:
	// RXgN^
	CDXDefaultSwapChain(void);
	// fXgN^
	virtual ~CDXDefaultSwapChain(void);
public:
	// 쐬
	virtual bool	Create(void);
	// ̈̍XV
	virtual bool	ReSize(UINT width, UINT height);
};

/// Xbv`F[NX
class CDXSwapChain : public IDXSwapChain
{
private:
	LPDXSURFACE		m_pPreSurface;	//!< ȑÕobNobt@
	LPDXSURFACE		m_pStencil;		//!< XeVobt@
	LPDXSURFACE		m_pPreStencil;	//!< ȑÕXeVobt@
	DXPRESENT_PARAMETERS	m_Present;
	HWND					m_hWnd;
public:
	// RXgN^
	CDXSwapChain(void);
	// fXgN^
	virtual ~CDXSwapChain(void);
public:
	// 
	virtual bool	Initialize(HWND hWnd, UINT width, UINT height);
	// 쐬
	virtual bool	Create(void);
	// ̈̍XV
	virtual bool	ReSize(UINT width, UINT height);
	// 
	virtual	void	Release(void);
public:
	// `̊Jn
	virtual	bool	BeginScene(D3DCOLOR color=0xff101080, bool backbuffer=true, bool zbuffer=true);
	// `̏I
	virtual bool	EndScene(void);
public:
	virtual HWND								GetHWND(void)	const	{ return m_hWnd; }
	// present
	virtual LPCDXPRESENT_PARAMETERS const		GetPresent(void) const	{ return &m_Present; }
};


}	// end of namespace dx
}	// end of namespace iris

#endif
