//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXObject.h
 * @brief		DirectXfoCXIuWF̃x[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXObject_H_
#define INCG_IRIS_DXObject_H_

//======================================================================
// include
#include "../dx_inchead.h"
#include "DXDeviceObject.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class CDXDevice;
class IDXSwapChain;
class IDXGXObject;

//======================================================================
// class

/**
 * @brief	ׂĂDXObject̊NX
*/
class IDXGXObject : public IIrisObject
{
	friend class CDXDevice;		//!< @ref	iris::dx::CDXDevice		@note ǗNX̃ANZX
	friend class IDXSwapChain;	//!< @ref	iris::dx::IDXSwapChain
private:
	CDXDevice*			m_pDevice;		//!< foCXǗ
	IDXSwapChain*		m_pSwapChain;	//!< Xbv`FC
public:
	// RXgN^
	IDXGXObject(void);
	// fXgN^
	virtual ~IDXGXObject(void);
public:
	//! 쐬
	virtual bool	Create(void) = 0;
	//! 
	virtual	void	Release(void) = 0;

protected:
	//! Zbg
	virtual	void	Reset(void) = 0;
	//! XgA
	virtual	void	Restore(void) = 0;

public:
	//@o^̃`FC
	bool	RegisterChain(IDXGXObject* obj);

public:
	CDXDevice*						GetDXDevice(void)			{ return m_pDevice; }
	CDXDevice*						GetDXDevice(void) const		{ return m_pDevice; }
	IDXSwapChain*					GetDXSwapChain(void)		{ return m_pSwapChain; }
	IDXSwapChain*					GetDXSwapChain(void) const	{ return m_pSwapChain; }
	// wrap
	CDXDeviceX&						GetDeviceX(void)	const;
	LPCDXDEVICE						GetDevice(void)		const;
	LPCDXPRESENT_PARAMETERS const	GetPresent(void)	const;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPCDXSPRITE						GetSprite(void)		const;
#endif

private:
	// foCX̓o^
	void	SetDevice(CDXDevice* pDevice, IDXSwapChain* pSwapChain);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
