//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDirect3D.cpp
 * @brief		Direct3D t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXDirect3D_CPP_

//======================================================================
// include
#include "DXDirect3D.h"
#include "DxError.h"
#include "iris_debug.h"

//======================================================================
// link
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#  pragma comment (lib, "d3dx" IRIS_PP_TOSTRING(_IRIS_DXSDK_TARGET_VER) ".lib")
#  pragma comment (lib, "dxguid.lib")
#else
#  pragma comment (lib, "d3dmx.lib")
#endif

//======================================================================
// define
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#  define	DXLIB_NAME		"d3d" IRIS_PP_TOSTRING(_IRIS_DXSDK_TARGET_VER)
#else
#  define	DXLIB_NAME		"d3dm"
#endif

#define DXLIB_FILENAME		DXLIB_NAME IRIS_LIB_POSTFIX ".dll"

namespace iris {
namespace dx
{

//======================================================================
// variable
namespace
{
	static CDirect3D	s_Direct3D;
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDirect3D::CDirect3D(void)
: m_lpD3D(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDirect3D::~CDirect3D(void)
{
	Unload();
}

/**********************************************************************//**
 *
 * [h
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDirect3D::Load(void)
{
	if( !m_Module.IsValid() )
	{
		if( !m_Module.Load(DXLIB_FILENAME) ) return false;
	}

	if( m_lpD3D == nullptr )
	{
		typedef LPDIRECT3D (__stdcall *D3DCREATETYPE)(UINT);
#if	defined(DX_SDK_VERSION)
		D3DCREATETYPE d3dCreate = reinterpret_cast<D3DCREATETYPE>(m_Module.GetProcAddress("Direct3DCreate" IRIS_PP_TOSTRING(_IRIS_DXSDK_TARGET_VER)));
		if( d3dCreate == nullptr ) return false;
		m_lpD3D = (*d3dCreate)(D3D_SDK_VERSION);
#else
#endif
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDirect3D::Unload(void)
{
	DX_SAFE_RELEASE( m_lpD3D );
	m_Module.Release();
}

/**********************************************************************//**
 *
 * foCXIuWFNg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	Adapter						= A_v^[^Cv
 * @param [in]	DeviceType					= foCX^Cv
 * @param [in]	hFocusWindow				= tH[JXEBhEnh
 * @param [in]	BehaviorFlags				= 
 * @param [in]	pPresentationParameters		= \p[^
 * @param [out]	ppReturnedDeviceInterface	= o
 * @return	
*//***********************************************************************/
HRESULT	CDirect3D::CreateDevice(UINT Adapter, DXDEVTYPE DeviceType, HWND hFocusWindow, ULONG BehaviorFlags
	, LPDXPRESENT_PARAMETERS pPresentationParameters, LPDXDEVICE* ppReturnedDeviceInterface)
{
	IRIS_ASSERT( m_lpD3D != nullptr );
	return m_lpD3D->CreateDevice(Adapter, DeviceType, hFocusWindow, BehaviorFlags
		, pPresentationParameters,  ppReturnedDeviceInterface);
}


/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	Adapter			= A_v^[^Cv
 * @param [in]	DeviceType		= foCX^Cv
 * @param [in]	SurfaceFormat	= T[tFCXtH[}bg
 * @param [in]	Windowed		= tXN[ǂ
 * @param [in]	MultiSampleType	= 
 * @param [out]	lpQualityLevels	= 
 * @return	
*//***********************************************************************/
HRESULT CDirect3D::CheckDeviceMultiSampleType(UINT Adapter, DXDEVTYPE DeviceType, D3DFORMAT SurfaceFormat
		, BOOL Windowed, D3DMULTISAMPLE_TYPE MultiSampleType, LPDWORD lpQualityLevels)
{
	IRIS_ASSERT( m_lpD3D != nullptr );
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return m_lpD3D->CheckDeviceMultiSampleType(Adapter, DeviceType, SurfaceFormat, Windowed, MultiSampleType, lpQualityLevels);
#else
	IRIS_UNUSED_VARIABLE(lpQualityLevels);
	return m_lpD3D->CheckDeviceMultiSampleType(Adapter, DeviceType, SurfaceFormat, Windowed, MultiSampleType);
#endif
}

}	// end of namespace dx
}	// end of namespace iris
