//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapIO.h
 * @brief		io ֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WceWrapIO_CPP_

//======================================================================
// include
#include "WceWrapIO.h"

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// function
/**********************************************************************//**
 * @internal
 *
 * LockFile
 *
 -----------------------------------------------------------------------
 * @param [in]	hFile						= t@Cnh
 * @param [in]	dwFileOffsetLow				= 
 * @param [in]	dwFileOffsetHigh			= 
 * @param [in]	nNumberOfBytesToUnlockLow	= 
 * @param [in]	nNumberOfBytesToUnlockHigh	= 
*//***********************************************************************/
BOOL	WINAPI	LockFile(HANDLE hFile, DWORD dwFileOffsetLow, DWORD dwFileOffsetHigh, DWORD nNumberOfBytesToLockLow, DWORD nNumberOfBytesToLockHigh)
{
	OVERLAPPED ovl;
	ovl.Offset = dwFileOffsetLow;
	ovl.OffsetHigh = dwFileOffsetHigh;
	return LockFileEx(hFile, LOCKFILE_FAIL_IMMEDIATELY, 0, nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh, &ovl);
}

/**********************************************************************//**
 * @internal
 *
 * UnlockFile
 *
 -----------------------------------------------------------------------
 * @param [in]	hFile						= t@Cnh
 * @param [in]	dwFileOffsetLow				= 
 * @param [in]	dwFileOffsetHigh			= 
 * @param [in]	nNumberOfBytesToUnlockLow	= 
 * @param [in]	nNumberOfBytesToUnlockHigh	= 
*//***********************************************************************/
BOOL	WINAPI	UnlockFile(HANDLE hFile, DWORD dwFileOffsetLow, DWORD dwFileOffsetHigh, DWORD nNumberOfBytesToUnlockLow, DWORD nNumberOfBytesToUnlockHigh)
{
	OVERLAPPED ovl;
	ovl.Offset = dwFileOffsetLow;
	ovl.OffsetHigh = dwFileOffsetHigh;
	return UnlockFileEx(hFile, 0, nNumberOfBytesToUnlockLow, nNumberOfBytesToUnlockHigh, &ovl);
}

/**********************************************************************//**
 * @internal
 *
 * RegOpenKeyA, W
 *
 -----------------------------------------------------------------------
 * @param [in]	hKey		= WXgL[
 * @param [in]	lpSubKey	= TuL[
 * @param [out]	phkResult	= o
*//***********************************************************************/
LSTATUS	APIENTRY	RegOpenKeyA (HKEY hKey, LPCSTR lpSubKey, PHKEY phkResult)
{
#if !defined(IRIS_WIN32_WCE)
	return RegOpenKeyExA(hKey, lpSubKey, 0, KEY_ALL_ACCESS, phkResult);
#else
	return ERROR_INVALID_FUNCTION;
#endif
}
LSTATUS	APIENTRY	RegOpenKeyW (HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult)
{
	return RegOpenKeyExW(hKey, lpSubKey, 0, KEY_ALL_ACCESS, phkResult);
}

/**********************************************************************//**
 * @internal
 *
 * RegQueryValueA, W
 *
 -----------------------------------------------------------------------
 * @param [in]	hKey		= WXgL[
 * @param [in]	lpSubKey	= TuL[
 * @param [out]	lpData		= o
 * @param [io]	lpcbData	= o̓TCY
*//***********************************************************************/
LSTATUS	APIENTRY	RegQueryValueA (HKEY hKey, LPCSTR lpSubKey, LPSTR lpData, PLONG lpcbData)
{
#if !defined(IRIS_WIN32_WCE)
	DWORD dwType;
	return RegQueryValueExA(hKey, lpSubKey, nullptr, &dwType, (LPBYTE)lpData, (LPDWORD)lpcbData);
#else
	return ERROR_INVALID_FUNCTION;
#endif
}
LSTATUS	APIENTRY	RegQueryValueW (HKEY hKey, LPCWSTR lpSubKey, LPWSTR lpData, PLONG lpcbData)
{
	DWORD dwType;
	return RegQueryValueExW(hKey, lpSubKey, nullptr, &dwType, (LPBYTE)lpData, (LPDWORD)lpcbData);
}

/**********************************************************************//**
 * @internal
 *
 * RegSetValueA, W
 *
 -----------------------------------------------------------------------
 * @param [in]	hKey		= WXgL[
 * @param [in]	lpSubKey	= TuL[
 * @param [in]	dwType		= L[^Cv
 * @param [in]	lpData		= 
 * @param [in]	cbData		= ̓TCY
*//***********************************************************************/
LSTATUS	APIENTRY	RegSetValueA (HKEY hKey, LPCSTR lpSubKey, DWORD dwType, LPCSTR lpData, DWORD cbData)
{
#if !defined(IRIS_WIN32_WCE)
	return RegSetValueExA(hKey, lpSubKey, 0, dwType, (const LPBYTE)lpData, cbData);
#else
	return ERROR_INVALID_FUNCTION;
#endif
}
LSTATUS	APIENTRY	RegSetValueW (HKEY hKey, LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData)
{
	return RegSetValueExW(hKey, lpSubKey, 0, dwType, (const LPBYTE)lpData, cbData);
}

/**********************************************************************//**
 * @internal
 *
 * RegSetValueA, W
 *
 -----------------------------------------------------------------------
 * @param [in]	hKey		= WXgL[
 * @param [in]	lpSubKey	= TuL[
 * @param [in]	dwType		= L[^Cv
 * @param [in]	lpData		= 
 * @param [in]	cbData		= ̓TCY
*//***********************************************************************/
LSTATUS	APIENTRY	RegEnumKeyA (HKEY hKey, DWORD dwIndex, LPSTR lpName, DWORD cchName)
{
#if !defined(IRIS_WIN32_WCE)
	DWORD dwcchName = cchName;
	return RegEnumKeyExA(hKey, dwIndex, lpName, &dwcchName, nullptr, nullptr, nullptr, nullptr);
#else
	return ERROR_INVALID_FUNCTION;
#endif
}
LSTATUS	APIENTRY	RegEnumKeyW (HKEY hKey, DWORD dwIndex, LPWSTR lpName, DWORD cchName)
{
	DWORD dwcchName = cchName;
	return RegEnumKeyExW(hKey, dwIndex, lpName, &dwcchName, nullptr, nullptr, nullptr, nullptr);
}

#endif
