//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		wce_support.h
 * @brief		Windows CE T|[gwb_ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_wce_support_H_
#define INCG_IRIS_wce_support_H_

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// include
#include "wce_inline.h"
#include "wce_wrap.h"
#include "wce_bugfix.h"

//======================================================================
// typedef
typedef LONG	__int3264;

//======================================================================
// define

// CEVER
#define WIN_CE4		0x420	// 4.2
#define WIN_CE5		0x502	// 5.02

#define IRIS_WCE_AT_LEAST(ver)		(IRIS_WIN32_WCE >= ver)
#define IRIS_WCE_AT_LESS(ver)		(IRIS_WIN32_WCE < ver)

#define WS_OVERLAPPEDWINDOW	WS_OVERLAPPED

#ifdef UNICODE
#  define FindWindowEx		FindWindowExW
#else
#  define FindWindowEx		FindWindowExA
#endif

#ifdef UNICODE
#  define CreateFont		CreateFontW
#else
#  define CreateFont		CreateFontA
#endif

#define SetWindowLongPtrA	SetWindowLongA
#define SetWindowLongPtrW	SetWindowLongW
#ifdef UNICODE
#  define SetWindowLongPtr	SetWindowLongPtrW
#else
#  define SetWindowLongPtr	SetWindowLongPtrA
#endif

#define GetWindowLongPtrA	GetWindowLongA
#define GetWindowLongPtrW	GetWindowLongW
#ifdef UNICODE
#  define GetWindowLongPtr	GetWindowLongPtrW
#else
#  define GetWindowLongPtr	GetWindowLongPtrA
#endif

#define GetMonitorInfoA		GetMonitorInfo
#define GetMonitorInfoW		GetMonitorInfo

#define MONITORINFOEXA		MONITORINFOEX
#define MONITORINFOEXW		MONITORINFOEX

#define LocalDiscard(hMem)	(hMem)
#define GlobalDiscard(hMem)	LocalDiscard(hMem)

#ifndef	AdjustWindowRect
#  define	AdjustWindowRect(lprc, dwStyle, bMenu)	AdjustWindowRectEx(lprc, dwStyle, bMenu, 0)
#endif

#ifndef SPIF_SENDWININICHANGE
#  define SPIF_SENDWININICHANGE	SPIF_SENDCHANGE
#endif

#define vswprintf_s(dst, size, fmt, va)		((void)(size), vswprintf(dst, fmt, va))
#define	vsnprintf(dst, size, src, va)		((void)(size), vsprintf(dst, src, va))
#define _vcprintf(fmt, va)					vprintf(fmt, va)
#define _vcwprintf(fmt, va)					vwprintf(fmt, va)
#define wctomb(mb, wc)						wcstombs(mb, &wc, 1)


#ifndef TPM_RIGHTBUTTON
#  define TPM_RIGHTBUTTON	0
#endif
#ifndef TPM_LEFTBUTTON
#  define TPM_LEFTBUTTON	0
#endif

#ifndef CB_DIR
#  define CB_DIR				0x0145
#endif
#ifndef LB_DIR
#  define LB_DIR				0x018D
#endif

#ifndef STM_SETICON
#  define STM_SETICON			0x0170
#endif
#ifndef STM_GETICON
#  define STM_GETICON			0x0171
#endif


// class name
#ifndef WC_BUTTON
#  define WC_BUTTONA			"Button"
#  define WC_BUTTONW			L"Button"
#  ifdef UNICODE
#    define WC_BUTTON			WC_BUTTONW
#  else
#    define WC_BUTTON			WC_BUTTONA
#  endif
#endif

#ifndef WC_STATIC
#  define WC_STATICA			"Static"
#  define WC_STATICW			L"Static"
#  ifdef UNICODE
#    define WC_STATIC			WC_STATICW
#  else
#    define WC_STATIC			WC_STATICA
#  endif
#endif

#ifndef WC_EDIT
#  define WC_EDITA				"Edit"
#  define WC_EDITW				L"Edit"
#  ifdef UNICODE
#    define WC_EDIT				WC_EDITW
#  else
#    define WC_EDIT				WC_EDITA
#  endif
#endif

#ifndef WC_LISTBOX
#  define WC_LISTBOXA			"ListBox"
#  define WC_LISTBOXW			L"ListBox"
#  ifdef UNICODE
#    define WC_LISTBOX			WC_LISTBOXW
#  else
#    define WC_LISTBOX			WC_LISTBOXA
#  endif
#endif

#ifndef WC_COMBOBOX
#  define WC_COMBOBOXA			"ComboBox"
#  define WC_COMBOBOXW			L"ComboBox"
#  ifdef UNICODE
#    define WC_COMBOBOX			WC_COMBOBOXW
#  else
#    define WC_COMBOBOX			WC_COMBOBOXA
#  endif
#endif

#ifndef WC_SCROLLBAR
#  define WC_SCROLLBARA			"ScrollBar"
#  define WC_SCROLLBARW			L"ScrollBar"
#  ifdef UNICODE
#    define WC_SCROLLBAR		WC_SCROLLBARW
#  else
#    define WC_SCROLLBAR		WC_SCROLLBARA
#  endif
#endif

#endif

#endif
