//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		apple_support.h
 * @brief		irisT|[g}Nwb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_apple_support_H_
#define INCG_IRIS_apple_support_H_

//======================================================================
// include
#ifdef	IRIS_IPHONE
#include "ipx_support.h"
#elif	IRIS_MAC
#include "mac_support.h"
#endif

//======================================================================
// function
inline LPSTR strrev(LPSTR const str)
{
	if( str != nullptr )
	{
		LPSTR p = str;
		LPSTR e = str;
		while(*e != '\0') ++e;
		if( p != e )
		{
			char tmp=0;
			--e;
			while( p <= e )
			{
				tmp = *p;
				*p = *e;
				*e = tmp;
				++p;
				--e;
			}
		}
	}
	return str;
}

//======================================================================
// define
// pX̋؂蕶
#define		FILESPEC_DIRECTORY_DELIMITER	'/'

// TODO : Ƃ肠ɋLq
// t@CpXő咷
#define MAX_PATH	260


//
#ifndef CDECL
#define CDECL		_cdecl
#endif

#ifndef CALLBACK
#define CALLBACK	PASCAL
#endif

#ifndef WINAPI
#define WINAPI		CDECL
#endif

#ifndef WINAPIV
#define WINAPIV		CDECL
#endif

#ifndef APIENTRY
#define APIENTRY    WINAPI
#endif

#ifndef APIPRIVATE
#define APIPRIVATE	CDECL
#endif

#ifndef PASCAL
#ifdef _68K_
#define PASCAL      pascal
#else
#define PASCAL
#endif
#endif

#endif
