//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkTriangleShape.h
 * @brief		Havok TriangleShape t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_HvkTriangleShape_H_
#define INCG_IRIS_HvkTriangleShape_H_

//======================================================================
// include
#include "HvkShape.h"

#ifdef _IRIS_SUPPORT_HAVOK
#include "Physics/Collide/Shape/Convex/Triangle/hkpTriangleShape.h"

namespace iris {
namespace havok
{

//======================================================================
// class
/// Shape NXC^[tFCX
class CTriangleShape : public IShape
{
public:
	// RXgN^
	CTriangleShape(void);
	// fXgN^
	virtual ~CTriangleShape(void);

public:
	// 쐬
	bool	Create(hkReal radius = hkConvexShapeDefaultRadius, hkUint16 weldingInfo = 0, hkpWeldingUtility::WeldingType type = hkpWeldingUtility::WELDING_TYPE_NONE);
	bool	Create(const hkVector4& v0, const hkVector4& v1, const hkVector4& v2, hkReal radius = hkConvexShapeDefaultRadius);
};


}	// end of namespace havok
}	// end of namespace iris

#endif

#endif
