//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkCapsuleShape.cpp
 * @brief		Havok CapsuleShape t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkCapsuleShape_CPP_

//======================================================================
// include
#include "HvkCapsuleShape.h"


#ifdef _IRIS_SUPPORT_HAVOK

namespace iris {
namespace havok
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCapsuleShape::CCapsuleShape(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCapsuleShape::~CCapsuleShape(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	vertexA	= JvZ̒[_
 * @param [in]	vertexB	= JvZ̒[_
 * @param [in]	radius	= a
 * @retrun	
*//***********************************************************************/
bool CCapsuleShape::Create(const hkVector4& vertexA, const hkVector4& vertexB, hkReal radius)
{
	Delete();
	m_ptr = new hkpCapsuleShape(vertexA, vertexB, radius);
	if( m_ptr == nullptr ) return false;
	return true;
}

}	// end of namespace havok
}	// end of namespace iris

#endif
