//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		hvk_inchead.h
 * @brief		Havok CN[hwb_ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_hvk_inchead_H_
#define INCG_IRIS_hvk_inchead_H_

//======================================================================
// include
#include "../../iris_inchead.h"

#ifdef _IRIS_SUPPORT_HAVOK

/**
 * @defgroup	Havok
*/

#include "Common/Base/Config/hkConfigVersion.h"

#define	HAVOKVER_AT_LEAST(major, minor)		(HAVOK_SDK_VERSION_MAJOR > (major) || (HAVOK_SDK_VERSION_MAJOR >= (major) && HAVOK_SDK_VERSION_MINOR >= (minor)) )
#define	HAVOKVER_AT_LESS(major, minor)		(HAVOK_SDK_VERSION_MAJOR < (major) || (HAVOK_SDK_VERSION_MAJOR <= (major) && HAVOK_SDK_VERSION_MINOR <  (minor)) )

#else
#define	HAVOKVER_AT_LEAST(major, minor)		0
#define	HAVOKVER_AT_LESS(major, minor)		0

#endif

#endif
