//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkWorld.h
 * @brief		Havok World t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_HvkWorld_H_
#define INCG_IRIS_HvkWorld_H_

//======================================================================
// include
#include "HvkRefObj.h"
#include "../../fnd/types/FndUpdater.h"

#ifdef _IRIS_SUPPORT_HAVOK
#include "Physics/Dynamics/World/hkpWorld.h"

namespace iris {
namespace havok
{

//======================================================================
// class
/**
 * @ingroup	Havok
 * @brief	World NX
*/
class CWorld : public CRefObj<hkpWorld>, public fnd::IUpdater
{
public:
	// RXgN^
	CWorld(void);
	// fXgN^
	virtual ~CWorld(void);

public:
	// 쐬
	bool	Create(hkpWorldCinfo::SimulationType simType, hkReal tolerance, hkReal worldSize
					, hkpWorldCinfo::SolverType solverType, hkVector4& gravity);
	bool	Create(hkpWorldCinfo& info);
	// 폜
	void	Delete(void);

public:
	void	Update(xf32 time);
};


}	// end of namespace havok
}	// end of namespace iris

#endif

#endif
