//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		HvkRigid.cpp
 * @brief		Havok Rigid t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_HvkRigid_CPP_

//======================================================================
// include
#include "HvkRigid.h"


#ifdef _IRIS_SUPPORT_HAVOK

namespace iris {
namespace havok
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRigid::CRigid(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRigid::~CRigid(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	mass		= 
 * @param [in]	pShape		= `
 * @param [in]	MotionType	= ړ^Cv
 * @param [in]	position	= ʒu
 * @return	
*//***********************************************************************/
bool CRigid::Create(hkReal mass, hkpShape* pShape, hkpMotion::MotionType motionType, const hkVector4& position)
{
	hkpRigidBodyCinfo info;
	info.m_mass = mass;
	info.m_shape = pShape;
	info.m_motionType = motionType;
	info.m_position = position;
	return Create(info);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	info	= 
 * @return	
*//***********************************************************************/
bool CRigid::Create(hkpRigidBodyCinfo& info)
{
	Delete();
	m_ptr = new hkpRigidBody(info);
	if( m_ptr == nullptr ) return false;
	return true;
}

}	// end of namespace havok
}	// end of namespace iris

#endif
