//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_pow.hpp
 * @brief		iris meta language operator t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_pow_HPP_
#define INCG_IRIS_iml_pow_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"
#include "../detail/iml_detail.hpp"
#include "../iml_constant.hpp"
#include "../iml_type_select.hpp"

namespace iml
{

//======================================================================
// class
/**
 * @brief	ׂ
*/
template<intmax_t V1, intmax_t V2>
class static_pow
{
	template<intmax_t T1, intmax_t T2, intmax_t A1>
	struct pow_impl
	{
		static const intmax_t value = pow_impl<T1, T2-1, A1*T1>::value;
	};
	template<intmax_t T1, intmax_t A1>
	struct pow_impl<T1, 1, A1>
	{
		static const intmax_t value = A1;
	};
	template<intmax_t T1, intmax_t A1>
	struct pow_impl<T1, 0, A1>
	{
		static const intmax_t value = 1;
	};
	template<intmax_t T2, intmax_t A1>
	struct pow_impl<0, T2, A1>
	{
		static const intmax_t value = 0;
	};
	template<intmax_t A1>
	struct pow_impl<0, 0, A1>
	{
		static const intmax_t value = 1;
	};
public:
	static const intmax_t value = pow_impl<V1, V2, V1>::value;
};

/**
 * @brief	2̙p悩ǂ
*/
template<intmax_t V>
class static_is_pow2 : public iml::type_select< ((V > 0) && ((V & (V - 1)) == 0)), iml::detail::true_type, iml::detail::false_type >::type
{
};

}	// end of namespace iml

#endif
