//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_seald.hpp
 * @brief		iris meta language seald t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_seald_HPP_
#define INCG_IRIS_iml_seald_HPP_

//======================================================================
// include

namespace iml
{

//================================================================================
// declare
template<class T>class sealed_t;

//================================================================================
// class

namespace detail
{

template<typename T>
class sealed_base
{
	template <typename X> struct identity { typedef X type;	};
#if		defined(__GNUC__) || defined(__MWERKS__)
	friend class identity<T>::type;
#else
	friend identity<T>::type;
#endif
	friend class sealed_t<T>;
	sealed_base(void)				{}
	sealed_base(const sealed_base&)	{}
};

}

/**
 * @brief	V[hNX
 * @details	p֎~i邭j܂B
 *			p̃NX̐}܂B
 * @per		sample
void main( void )\n
{\n
	struct p : public sealed<p>{};\n
	struct q : public p{};\n
\n
	p a;\n
//	q b;// error\n
	q* b = (q*)new p;// ok\n
}\n
*/
template <class T>
class sealed_t : public virtual detail::sealed_base<T> {};


}	// end of namespace iml

#endif
