//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_swap.hpp
 * @brief		iris meta language algorithm swap t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_swap_HPP_
#define INCG_IRIS_iml_swap_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"
#include "../../c++0x/cpp0x_type_traits.hpp"

namespace iml
{

//======================================================================
// class

namespace detail
{

template<bool Integer_, typename TN>
struct swap_impl
{
	static void swap(TN& a, TN& b)
	{
		TN tmp = a;
		a = b;
		b = tmp;
	}
};

template<typename TN>
struct swap_impl<true, TN>
{
	static void swap(TN& a, TN& b)
	{
		a ^= b;
		b ^= a;
		a ^= b;
	}
};

}	// end of namespace detail

/**
 * @brief	swap
*/
template<typename TN>
void swap(TN& a, TN& b)
{
	detail::swap_impl< cpp0x::is_integral<TN>::value, TN >::swap(a, b);
}


}	// end of namespace iml

#endif
