//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_prime_number.hpp
 * @brief		iris meta language algorithm prime_number t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_prime_number_HPP_
#define INCG_IRIS_iml_prime_number_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"
#include "../detail/iml_detail.hpp"
#include "../iml_type_select.hpp"
#include "../iml_constant.hpp"
#include "../../preprocessor/PPPrograming.h"

namespace iml
{

//======================================================================
// class
/**
 * @brief	prime_number
 * @tparam	V	= 肵l
*/
template<intmax_t V>
class is_prime_number
{
	static const intmax_t	RECURSIVE_MAX=200;	//!< ċA

	template<intmax_t N, intmax_t D1, intmax_t D2, intmax_t Cnt, intmax_t Max>
	struct is_prime_calc_recursive0
	{
			typedef typename type_select<(N%D1==0) || (N%D2==0), detail::false_type
			, typename is_prime_calc_recursive0<N, D1+6, D2+6, Cnt+1, Max>::type>::type type;
#if 1
		// D*D > N ̍œK
		static const intmax_t TMP1 = ((D1)*(D1) > N) ? N : is_prime_calc_recursive0<N, D1+6, D2+6, Cnt+1, Max>::TMP1;
		static const intmax_t TMP2 = ((D2)*(D2) > N) ? N : is_prime_calc_recursive0<N, D1+6, D2+6, Cnt+1, Max>::TMP2;
#else
		static const intmax_t TMP1 = typename is_prime_calc_recursive0<N, D1+6, D2+6, Cnt+1, Max>::TMP1;
		static const intmax_t TMP2 = typename is_prime_calc_recursive0<N, D1+6, D2+6, Cnt+1, Max>::TMP2;
#endif
		typedef char e[ Max ? 1 : -1];
	};
	template<intmax_t N, intmax_t D1, intmax_t Max>
	struct is_prime_calc_recursive0<N, D1, N, Max, Max>
	{
		static const intmax_t	TMP1=D1;
		static const intmax_t	TMP2=N;
		typedef detail::true_type type;
		typedef char e[ Max ? 1 : -1];
	};
	template<intmax_t N, intmax_t D2, intmax_t Max>
	struct is_prime_calc_recursive0<N, N, D2, Max, Max>
	{
		static const intmax_t	TMP1=N;
		static const intmax_t	TMP2=D2;
		typedef detail::true_type type;
		typedef char e[ Max ? 1 : -1];
	};
	template<intmax_t N, intmax_t D1, intmax_t D2, intmax_t Max>
	struct is_prime_calc_recursive0<N, D1, D2, Max, Max>
	{
		static const intmax_t	TMP1= D1;
		static const intmax_t	TMP2= D2;
		typedef detail::true_type type;
		typedef char e[ Max ? 1 : -1];
	};
	template<intmax_t N, intmax_t D1, intmax_t Cnt, intmax_t Max>
	struct is_prime_calc_recursive0<N, D1, N, Cnt, Max>
	{
		static const intmax_t	TMP1=D1;
		static const intmax_t	TMP2=N;
		typedef detail::true_type type;
		typedef char e[ Max ? 1 : -1];
	};
	template<intmax_t N, intmax_t D2, intmax_t Cnt, intmax_t Max>
	struct is_prime_calc_recursive0<N, N, D2, Cnt, Max>
	{
		static const intmax_t	TMP1=N;
		static const intmax_t	TMP2=D2;
		typedef detail::true_type type;
		typedef char e[ Max ? 1 : -1];
	};

#define IML_PRIME_NUMBER_RECURSIVE_IMPL(index)	\
	template<intmax_t N, intmax_t D1, intmax_t D2, intmax_t Cnt, intmax_t Max>	\
	struct is_prime_calc_recursive##index							\
	{																\
		static const bool value = IRIS_PP_CAT(is_prime_calc_recursive, IRIS_PP_DEC(index))<N, D1, D2, 0, Max-Cnt>::type::value;	\
		static const intmax_t TMP1 = IRIS_PP_CAT(is_prime_calc_recursive, IRIS_PP_DEC(index))<N, D1, D2, 0, Max-Cnt>::TMP1;		\
		static const intmax_t TMP2 = IRIS_PP_CAT(is_prime_calc_recursive, IRIS_PP_DEC(index))<N, D1, D2, 0, Max-Cnt>::TMP2;		\
		typedef typename type_select<value															\
			, typename is_prime_calc_recursive##index<N, TMP1, TMP2, Cnt+1, Max >::type				\
			, detail::false_type >::type type;														\
	};																								\
	template<intmax_t N, intmax_t D1, intmax_t D2, intmax_t Max>									\
	struct is_prime_calc_recursive##index<N, D1, D2, Max, Max>										\
	{																								\
		static const intmax_t	TMP1=D1;															\
		static const intmax_t	TMP2=D2;															\
		typedef detail::true_type type;																\
	};																								\
	template<intmax_t N, intmax_t D2, intmax_t Cnt, intmax_t Max>									\
	struct is_prime_calc_recursive##index<N, N, D2, Cnt, Max>										\
	{																								\
		static const intmax_t	TMP1=N;																\
		static const intmax_t	TMP2=D2;															\
		typedef detail::true_type type;																\
	};																								\
	template<intmax_t N, intmax_t D1, intmax_t Cnt, intmax_t Max>									\
	struct is_prime_calc_recursive##index<N, D1, N, Cnt, Max>										\
	{																								\
		static const intmax_t	TMP1=D1;															\
		static const intmax_t	TMP2=N;																\
		typedef detail::true_type type;																\
	};																								\
	template<intmax_t N, intmax_t Cnt, intmax_t Max>												\
	struct is_prime_calc_recursive##index<N, N, N, Cnt, Max>										\
	{																								\
		static const intmax_t	TMP1=N;																\
		static const intmax_t	TMP2=N;																\
		typedef detail::true_type type;																\
	}

	IML_PRIME_NUMBER_RECURSIVE_IMPL(1);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(2);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(3);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(4);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(5);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(6);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(7);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(8);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(9);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(10);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(11);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(12);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(13);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(14);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(15);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(16);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(17);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(18);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(19);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(20);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(21);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(22);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(23);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(24);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(25);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(26);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(27);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(28);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(29);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(30);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(31);
	IML_PRIME_NUMBER_RECURSIVE_IMPL(32);


#undef IML_PRIME_NUMBER_RECURSIVE_IMPL

#define IML_PRIME_NUMBER_RECURSIVE_LEVEL	5
	template<intmax_t N, intmax_t D1, intmax_t D2>
	struct is_prime_calc_impl
	{
#if 0
		typedef typename type_select<(D1*D1 > N), detail::true_type
			, typename type_select<(((N%D1)==0) || ((N%D2)==0)), detail::false_type, typename is_prime_calc_impl<N, D1+6, D2+6>::type >::type >::type type;
#else
		static const bool value = IRIS_PP_CAT(is_prime_calc_recursive, IML_PRIME_NUMBER_RECURSIVE_LEVEL)<N, D1, D2, 0, RECURSIVE_MAX>::type::value;
		static const intmax_t TMP1 = IRIS_PP_CAT(is_prime_calc_recursive, IML_PRIME_NUMBER_RECURSIVE_LEVEL)<N, D1, D2, 0, RECURSIVE_MAX>::TMP1;
		static const intmax_t TMP2 = IRIS_PP_CAT(is_prime_calc_recursive, IML_PRIME_NUMBER_RECURSIVE_LEVEL)<N, D1, D2, 0, RECURSIVE_MAX>::TMP2;
		typedef typename type_select<value
			, typename is_prime_calc_impl<N, TMP1, TMP2>::type
			, detail::false_type >::type type;
#endif
	};
#undef IML_PRIME_NUMBER_RECURSIVE_LEVEL

	template<intmax_t N, intmax_t D1>
	struct is_prime_calc_impl<N, D1, N> { typedef detail::true_type type; };
	template<intmax_t N, intmax_t D2>
	struct is_prime_calc_impl<N, N, D2> { typedef detail::true_type type; };
	template<intmax_t N>
	struct is_prime_calc_impl<N, N, N>	{ typedef detail::true_type type; };

	template<intmax_t N, bool isSimpleFilter>
	struct is_prime_impl
	{
		// 11 傫̐lŊm
		//  7 n߂̂ŁA3, 5 ɂĂ͂ŎB
		typedef typename type_select<(N%3 == 0), detail::false_type
			, typename type_select<(N%5 == 0), detail::false_type
			, typename is_prime_calc_impl<N, 7, 13>::type >::type >::type type;
	};

	template<bool isSimpleFilter>
	struct is_prime_impl< 5, isSimpleFilter> { typedef detail::true_type type; };	// 5 ͑f
	template<bool isSimpleFilter>
	struct is_prime_impl< 3, isSimpleFilter> { typedef detail::true_type type; };	// 3 ͑f
	template<bool isSimpleFilter>
	struct is_prime_impl< 2, isSimpleFilter> { typedef detail::true_type type; };	// 2 ͑f

	template<intmax_t N>
	struct is_prime_impl<N, false>
	{
		// 1 傫RłȂA܂͋
		typedef detail::false_type type;
	};

	typedef typename is_prime_impl<V, (V > 1) && (((V&1) == 1) || V == 2) >::type type;
public:
	static const bool value = type::value;
};


}	// end of namespace iml

#endif
