//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_iterator.hpp
 * @brief		iris meta language algorithm iterator t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_iterator_HPP_
#define INCG_IRIS_iml_iterator_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"

namespace iml
{

//======================================================================
// class
/**
 * @name	iterator begin
 * @{
*/
template<typename TN, typename Iterator_t>
STATICINLINE Iterator_t iterator_begin(TN mass);

template<typename TN>
STATICINLINE typename TN::iterator iterator_begin(TN& mass)
{
	return mass.begin();
}
template<typename TN>
STATICINLINE typename TN::const_iterator iterator_begin(const TN& mass)
{
	return mass.begin();
}
template<typename TN, size_t SIZE>
STATICINLINE TN* iterator_begin(TN (&mass)[SIZE])
{
	return mass;
}
/**
 * @}
*/

/**
 * @name	iterator end
 * @{
*/
template<typename TN, typename Iterator_t>
STATICINLINE Iterator_t iterator_end(TN mass);

template<typename TN>
STATICINLINE typename TN::iterator iterator_end(TN& mass)
{
	return mass.end();
}
template<typename TN>
STATICINLINE typename TN::const_iterator iterator_end(const TN& mass)
{
	return mass.end();
}
template<typename TN, size_t SIZE>
STATICINLINE TN* iterator_end(TN (&mass)[SIZE])
{
	return mass + SIZE;
}
/**
 * @}
*/

}	// end of namespace iml

#endif
