//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_foreach.hpp
 * @brief		iris meta language algorithm foreach t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iml_foreach_HPP_
#define INCG_IRIS_iml_foreach_HPP_

//======================================================================
// include
#include "../../iris_stdint.h"

namespace iml
{

//======================================================================
// class
/**
 * @brief	foreach
*/
template<typename Iterator_t, typename Func_>
STATICINLINE void foreach(Iterator_t first, Iterator_t end, Func_& function)
{
	for( Iterator_t it = first; it != end; ++it )
		function (*it);
}

}	// end of namespace iml

#endif
