//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndSTDC.cpp
 * @brief		Wrand֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndSTDC_CPP_

//======================================================================
// include
#include "RndSTDC.h"
#include "../../ml/iml_math.hpp"
#include "../../iris_stdlib.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSTDCRand::CSTDCRand(void)
{
	SetSeed(88675123);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	seed	= 
*//***********************************************************************/
void CSTDCRand::SetSeed(u32 seed)
{
	IRand::SetSeed(seed);
	::srand(seed);
}

/**********************************************************************//**
 *
 * 32bit ̐
 *
*//***********************************************************************/
u32 CSTDCRand::GenRand32(void)
{
#if defined(RAND_MAX) && RAND_MAX
	static const intmax_t bits = iml::type_info<u32>::bits - iml::static_clz<u32, RAND_MAX>::value -1;
	static const intmax_t shift = bits - 8;
	IRIS_STATIC_ASSERT( bits >= 8 );

	u32 rnd = (static_cast<u32>(::rand()) >> shift) & 0xFF;
	rnd <<= 8;
	rnd |= (static_cast<u32>(::rand()) >> shift) & 0xFF;
	rnd <<= 8;
	rnd |= (static_cast<u32>(::rand()) >> shift) & 0xFF;
	rnd <<= 8;
	rnd |= (static_cast<u32>(::rand()) >> shift) & 0xFF;
	return rnd;
#else
	return static_cast<u32>(::rand());
#endif
}

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris
