/**
 * @file  SFMT.c
 * @brief SIMD oriented Fast Mersenne Twister(SFMT)
 *
 * @author Mutsuo Saito (Hiroshima University)
 * @author Makoto Matsumoto (Hiroshima University)
 *
 * Copyright (C) 2006,2007 Mutsuo Saito, Makoto Matsumoto and Hiroshima
 * University. All rights reserved.
 *
 * The new BSD License is applied to this software, see LICENSE.txt
 */
//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndSFMT.h
 * @brief		ZkEcCX^t@C
 * @note		irist[[NpɕύXĂ܂B
 *				\[X trunk/external/common/SFMT QƂĂB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_RndSFMT_H_
#define INCG_IRIS_RndSFMT_H_

//======================================================================
// include
#include "RndBase.h"
#include "RndSFMTTypes.h"
#include "../../ml/iml_padding.hpp"

//======================================================================
// define
#ifdef INCG_IRIS_RndSFMT_CPP_
#  define rnd_sfmt_protected	public
#else
#  define rnd_sfmt_protected	protected
#endif

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// struct
typedef struct tagSFMTCONTEXT
{
	uint32_t	parity[4];
	int			pos1;
	int			sl1, sl2;
	int			sr1, sr2;
	uint32_t	msk1, msk2, msk3, msk4;
} SFMTCONTEXT, *LPSFMTCONTEXT;

//======================================================================
// class
/**
 * @brief	ZkEcCX^
*/
template<u32 MEXP>
class CSFMT : public IRand
{
public:
	enum
	{
		N	= MEXP/128+1,
		N32	= N*4,
		N64 = N*2
	};
rnd_sfmt_protected:
	w128_t		m_psfmt[N];
	uint32_t*	m_psfmt32;
#if !defined(BIG_ENDIAN64) || defined(ONLY64)
/** the 64bit integer pointer to the 128-bit internal state array */
	uint64_t*	m_psfmt64;
#endif

	int			m_idx;
	bool		m_initialized;
	IRIS_PADDING( iml::padding<sizeof(bool)>::size );

public:
	SFMTCONTEXT			m_context;

public:
	// RXgN^
	CSFMT(void);

public:
	// ̐ݒ
	virtual void	SetSeed(u32 seed);
	virtual void	SetArraySeed(u32 *init_key, s32 key_length);

public:
	// 32bit ̐
	virtual u32		GenRand32(void);
	// 64bit ̐
	u64		GenRand64(void);
};

}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris

#endif
