//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		RndEvaluater.cpp
 * @brief		] t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_RndEvaluater_CPP_

//======================================================================
// include
#include "RndEvaluater.h"
#include "../../misc/iris_allegrex.h"
#include "../../fnd/utility/FndBitStream.h"

namespace iris {
namespace math {
namespace rnd
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CEvaluater::CEvaluater(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	pGen	= 
*//***********************************************************************/
CEvaluater::CEvaluater(IRand* pGen)
: CDistribution(pGen)
{
}

/**********************************************************************//**
 *
 * m
 *
 * @note	JC2挟
 *
 -----------------------------------------------------------------------
 * @param [out]	result	= x
 * @return	^Ul
*//***********************************************************************/
bool CEvaluater::Equiprobability(f32* result)
{
	static const int SECTION = 10;
	f32 chisq = Chisq(SECTION-1);
	if( result != nullptr ) *result = chisq;
	if( chisq > 16.919f ) return false;
	return true;
}

/**********************************************************************//**
 *
 * Mono Test
 *
 * @note	20000 bit ̗ɑ΂āAbit 1 ̌ x 
 *			9725 < x < 10275 𖞂
 *
 -----------------------------------------------------------------------
 * @param [out]	result	= x
 * @return	^Ul
*//***********************************************************************/
bool CEvaluater::MonoTest(int* result)
{
	int x=0;
	u32 buf[20000/sizeof(u32)/CHAR_BIT];
	FillRand32(buf, sizeof(buf)/sizeof(buf[0]));
	for( int i=0; i < sizeof(buf)/sizeof(buf[0]); ++i )
	{
		x += iris_allegrex_cao(buf[i]);
	}
	if( result != nullptr ) *result = x;
	return (x >= 9725) && (x <= 10275);
}


}	// end of namespace rnd
}	// end of namespace math
}	// end of namespace iris
