//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPrimeEratosthenes.h
 * @brief		MathPrimeEratosthenes t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPrimeEratosthenes_H_
#define INCG_IRIS_MathPrimeEratosthenes_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_inttypes.h"
#include <list>
#include <vector>

namespace iris {
namespace math
{

//======================================================================
// class
/**
 * @brief	GgXelX⿖@
*/
class CPrimeEratosthenes : public IIrisObject
{
	static const int	OPTIMIZE	= 5;
public:
	static const int BIT = 32;
	typedef int_least_type<BIT>::UInt	value_type;
	typedef std::vector<value_type>	list_type;

private:
	list_type	m_Primes;	// fXg
	value_type	m_Max;		// 肵ől

public:
	// RXgN^
	CPrimeEratosthenes(void);
	// fXgN^
	~CPrimeEratosthenes(void);

public:
	void	Initialize(void);
	void	Initialize(const list_type& def);
	void	Clear(void);

public:
	// w̐l܂ł̑fXgAbv
	void	Listup(value_type uMax);

public:
	/// Xg̎擾
	const list_type&	GetList(void)	const { return m_Primes; }
	/// f̎擾
	value_type			GetPrime(int index)	const	{ return m_Primes[index]; }

	/// Xg̗L
	bool	IsEmpty(void) const	{ return m_Primes.empty(); }
};

}	// end of namespace math
}	// end of namespace iris

#endif
